/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.spring.boot;

import com.ibm.cloud.sdk.core.security.Authenticator;
import com.ibm.cloud.sdk.core.security.BasicAuthenticator;
import com.ibm.cloud.sdk.core.security.ConfigBasedAuthenticatorFactory;
import com.ibm.cloud.sdk.core.security.IamAuthenticator;
import com.ibm.cloud.sdk.core.service.BaseService;
import com.ibm.watson.assistant.v1.Assistant;
import com.ibm.watson.compare_comply.v1.CompareComply;
import com.ibm.watson.developer_cloud.spring.boot.ConditionalOnWatsonServiceProperties;
import com.ibm.watson.developer_cloud.spring.boot.WatsonApiKeyAuthenticator;
import com.ibm.watson.developer_cloud.spring.boot.WatsonAssistantConfigurationProperties;
import com.ibm.watson.developer_cloud.spring.boot.WatsonCompareComplyConfigurationProperties;
import com.ibm.watson.developer_cloud.spring.boot.WatsonConfigurationProperties;
import com.ibm.watson.developer_cloud.spring.boot.WatsonDiscoveryConfigurationProperties;
import com.ibm.watson.developer_cloud.spring.boot.WatsonLanguageTranslatorConfigurationProperties;
import com.ibm.watson.developer_cloud.spring.boot.WatsonNaturalLanguageClassifierConfigurationProperties;
import com.ibm.watson.developer_cloud.spring.boot.WatsonNaturalLanguageUnderstandingConfigurationProperties;
import com.ibm.watson.developer_cloud.spring.boot.WatsonPersonalityInsightsConfigurationProperties;
import com.ibm.watson.developer_cloud.spring.boot.WatsonSpeechToTextConfigurationProperties;
import com.ibm.watson.developer_cloud.spring.boot.WatsonTextToSpeechConfigurationProperties;
import com.ibm.watson.developer_cloud.spring.boot.WatsonToneAnalyzerConfigurationProperties;
import com.ibm.watson.developer_cloud.spring.boot.WatsonVisualRecognitionConfigurationProperties;
import com.ibm.watson.discovery.v1.Discovery;
import com.ibm.watson.language_translator.v3.LanguageTranslator;
import com.ibm.watson.natural_language_classifier.v1.NaturalLanguageClassifier;
import com.ibm.watson.natural_language_understanding.v1.NaturalLanguageUnderstanding;
import com.ibm.watson.personality_insights.v3.PersonalityInsights;
import com.ibm.watson.speech_to_text.v1.SpeechToText;
import com.ibm.watson.text_to_speech.v1.TextToSpeech;
import com.ibm.watson.tone_analyzer.v3.ToneAnalyzer;
import com.ibm.watson.visual_recognition.v3.VisualRecognition;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={WatsonAssistantConfigurationProperties.class, WatsonCompareComplyConfigurationProperties.class, WatsonDiscoveryConfigurationProperties.class, WatsonLanguageTranslatorConfigurationProperties.class, WatsonNaturalLanguageClassifierConfigurationProperties.class, WatsonNaturalLanguageUnderstandingConfigurationProperties.class, WatsonPersonalityInsightsConfigurationProperties.class, WatsonSpeechToTextConfigurationProperties.class, WatsonTextToSpeechConfigurationProperties.class, WatsonToneAnalyzerConfigurationProperties.class, WatsonVisualRecognitionConfigurationProperties.class})
public class WatsonAutoConfiguration {
    @Autowired
    private WatsonAssistantConfigurationProperties assistantConfig;
    @Autowired
    private WatsonCompareComplyConfigurationProperties compareComplyConfig;
    @Autowired
    private WatsonDiscoveryConfigurationProperties discoveryConfig;
    @Autowired
    private WatsonLanguageTranslatorConfigurationProperties ltConfig;
    @Autowired
    private WatsonNaturalLanguageClassifierConfigurationProperties nlcConfig;
    @Autowired
    private WatsonNaturalLanguageUnderstandingConfigurationProperties nluConfig;
    @Autowired
    private WatsonPersonalityInsightsConfigurationProperties piConfig;
    @Autowired
    private WatsonSpeechToTextConfigurationProperties sttConfig;
    @Autowired
    private WatsonTextToSpeechConfigurationProperties ttsConfig;
    @Autowired
    private WatsonToneAnalyzerConfigurationProperties taConfig;
    @Autowired
    private WatsonVisualRecognitionConfigurationProperties vrConfig;

    private void configUrl(BaseService service, WatsonConfigurationProperties config) {
        String url = config.getUrl();
        if (url != null) {
            service.setServiceUrl(url);
        }
    }

    private Authenticator configAuth(WatsonConfigurationProperties config, String serviceName) {
        String iamApiKey = config.getIamApiKey();
        if (iamApiKey != null) {
            return new IamAuthenticator(iamApiKey);
        }
        String username = config.getUsername();
        String password = config.getPassword();
        if (username != null && password != null) {
            return new BasicAuthenticator(username, password);
        }
        String apiKey = config.getApiKey();
        if (apiKey != null) {
            return new WatsonApiKeyAuthenticator(apiKey);
        }
        return ConfigBasedAuthenticatorFactory.getAuthenticator((String)serviceName);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnWatsonServiceProperties(prefix="watson.assistant")
    public Assistant assistant() {
        Authenticator authConfig = this.configAuth(this.assistantConfig, "assistant");
        Assistant service = new Assistant(this.assistantConfig.getVersionDate(), authConfig);
        this.configUrl((BaseService)service, this.assistantConfig);
        return service;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnWatsonServiceProperties(prefix="watson.compare-comply")
    public CompareComply compareComply() {
        Authenticator authConfig = this.configAuth(this.compareComplyConfig, "compare_comply");
        CompareComply service = new CompareComply(this.compareComplyConfig.getVersionDate(), authConfig);
        this.configUrl((BaseService)service, this.compareComplyConfig);
        return service;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnWatsonServiceProperties(prefix="watson.discovery")
    public Discovery discovery() {
        Authenticator authConfig = this.configAuth(this.discoveryConfig, "discovery");
        Discovery service = new Discovery(this.discoveryConfig.getVersionDate(), authConfig);
        this.configUrl((BaseService)service, this.discoveryConfig);
        return service;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnWatsonServiceProperties(prefix="watson.language-translator")
    public LanguageTranslator languageTranslator() {
        Authenticator authConfig = this.configAuth(this.ltConfig, "language_translator");
        LanguageTranslator service = new LanguageTranslator(this.ltConfig.getVersionDate(), authConfig);
        this.configUrl((BaseService)service, this.ltConfig);
        return service;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnWatsonServiceProperties(prefix="watson.natural-language-classifier")
    public NaturalLanguageClassifier naturalLanguageClassifier() {
        Authenticator authConfig = this.configAuth(this.nlcConfig, "natural_language_classifier");
        NaturalLanguageClassifier service = new NaturalLanguageClassifier(authConfig);
        this.configUrl((BaseService)service, this.nlcConfig);
        return service;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnWatsonServiceProperties(prefix="watson.natural-language-understanding")
    public NaturalLanguageUnderstanding naturalLanguageUnderstanding() {
        Authenticator authConfig = this.configAuth(this.nluConfig, "natural_language_understanding");
        NaturalLanguageUnderstanding service = new NaturalLanguageUnderstanding(this.nluConfig.getVersionDate(), authConfig);
        this.configUrl((BaseService)service, this.nluConfig);
        return service;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnWatsonServiceProperties(prefix="watson.personality-insights")
    public PersonalityInsights personalityInsights() {
        Authenticator authConfig = this.configAuth(this.piConfig, "personality_insights");
        PersonalityInsights service = new PersonalityInsights(this.piConfig.getVersionDate(), authConfig);
        this.configUrl((BaseService)service, this.piConfig);
        return service;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnWatsonServiceProperties(prefix="watson.speech-to-text")
    public SpeechToText speechToText() {
        Authenticator authConfig = this.configAuth(this.sttConfig, "speech_to_text");
        SpeechToText service = new SpeechToText(authConfig);
        this.configUrl((BaseService)service, this.sttConfig);
        return service;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnWatsonServiceProperties(prefix="watson.text-to-speech")
    public TextToSpeech textToSpeech() {
        Authenticator authConfig = this.configAuth(this.ttsConfig, "text_to_speech");
        TextToSpeech service = new TextToSpeech(authConfig);
        this.configUrl((BaseService)service, this.ttsConfig);
        return service;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnWatsonServiceProperties(prefix="watson.tone-analyzer")
    public ToneAnalyzer toneAnalyzer() {
        Authenticator authConfig = this.configAuth(this.taConfig, "tone_analyzer");
        ToneAnalyzer service = new ToneAnalyzer(this.taConfig.getVersionDate(), authConfig);
        this.configUrl((BaseService)service, this.taConfig);
        return service;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnWatsonServiceProperties(prefix="watson.visual-recognition")
    public VisualRecognition visualRecognition() {
        Authenticator authConfig = this.configAuth(this.vrConfig, "visual_recognition");
        VisualRecognition service = new VisualRecognition(this.vrConfig.getVersionDate(), authConfig);
        this.configUrl((BaseService)service, this.vrConfig);
        return service;
    }
}

