/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.spring.boot;

import com.ibm.cloud.sdk.core.security.Authenticator;
import okhttp3.Request;
import org.apache.commons.lang3.StringUtils;

public class WatsonApiKeyAuthenticator
implements Authenticator {
    private String apiKey;

    public WatsonApiKeyAuthenticator(String apiKey) {
        this.apiKey = apiKey;
        this.validate();
    }

    public void validate() {
        if (StringUtils.isEmpty((CharSequence)this.apiKey)) {
            throw new IllegalArgumentException(String.format("The %s property is required but was not specified.", "apiKey"));
        }
    }

    public String authenticationType() {
        return "apiKey";
    }

    public void authenticate(Request.Builder builder) {
        builder.addHeader("Authorization", "Basic " + this.apiKey);
    }

    public String getApiKey() {
        return this.apiKey;
    }
}

