/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.visual_insights.v1;

import com.ibm.watson.developer_cloud.service.Request;
import com.ibm.watson.developer_cloud.service.WatsonService;
import com.ibm.watson.developer_cloud.visual_insights.v1.model.Classifiers;
import com.ibm.watson.developer_cloud.visual_insights.v1.model.Summary;
import java.io.File;
import java.util.HashMap;
import org.apache.http.HttpEntity;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;

public class VisualInsights
extends WatsonService {
    private static final String FILE = "file";
    private static final String CLASSIFIERS_PATH = "/v1/classifiers";
    private static final String SUMMARY_PATH = "/v1/summary";
    public static final String FILTER_NAME = "filter_name";
    private static final String URL = "https://gateway.watsonplatform.net/visual-insights-experimental/api";

    public VisualInsights() {
        this.setEndPoint(URL);
    }

    public Classifiers getClassifiers() {
        Request request = Request.Get(CLASSIFIERS_PATH, new Object[0]);
        return this.executeRequest(request, Classifiers.class);
    }

    public Classifiers getClassifiers(String filterName) {
        Request request = Request.Get(CLASSIFIERS_PATH, new Object[0]);
        if (filterName != null && !filterName.isEmpty()) {
            HashMap<String, Object> queryParameters = new HashMap<String, Object>();
            queryParameters.put(FILTER_NAME, filterName);
            request.withQuery(queryParameters);
        }
        return this.executeRequest(request, Classifiers.class);
    }

    public Summary getSummary(File imagesFile) {
        if (imagesFile == null || !imagesFile.exists()) {
            throw new IllegalArgumentException("imagesFile can not be null or empty");
        }
        MultipartEntity reqEntity = new MultipartEntity();
        reqEntity.addPart(FILE, (ContentBody)new FileBody(imagesFile));
        Request request = Request.Post(SUMMARY_PATH, new Object[0]).withEntity((HttpEntity)reqEntity);
        return this.executeRequest(request, Summary.class);
    }
}

