/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.tradeoff_analytics.v1.util;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.ibm.watson.developer_cloud.tradeoff_analytics.v1.model.column.CategoricalColumn;
import com.ibm.watson.developer_cloud.tradeoff_analytics.v1.model.column.Column;
import com.ibm.watson.developer_cloud.tradeoff_analytics.v1.model.column.DateColumn;
import com.ibm.watson.developer_cloud.tradeoff_analytics.v1.model.column.NumericColumn;
import com.ibm.watson.developer_cloud.tradeoff_analytics.v1.model.column.TextColumn;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ColumnTypeAdapter
extends TypeAdapter<Column> {
    private static final Logger log = Logger.getLogger(ColumnTypeAdapter.class.getName());
    private final DateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'");

    public Column read(JsonReader reader) throws IOException {
        Column column;
        if (reader.peek() == JsonToken.NULL) {
            reader.nextNull();
            return null;
        }
        Column.ColumnType type = Column.ColumnType.TEXT;
        Column.Goal goal = null;
        Boolean objective = null;
        String key = null;
        String format = null;
        String description = null;
        String fullName = null;
        String low = null;
        String high = null;
        Double significantGain = null;
        Double significantLoss = null;
        Double insignificantLoss = null;
        ArrayList<String> categoricalRange = null;
        ArrayList<String> categoricalPreference = null;
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("type")) {
                type = Column.ColumnType.fromString(reader.nextString());
                continue;
            }
            if (name.equals("key")) {
                key = reader.nextString();
                continue;
            }
            if (name.equals("goal")) {
                goal = Column.Goal.fromString(reader.nextString());
                continue;
            }
            if (name.equals("is_objective")) {
                objective = reader.nextBoolean();
                continue;
            }
            if (name.equals("format")) {
                format = reader.nextString();
                continue;
            }
            if (name.equals("description")) {
                description = reader.nextString();
                continue;
            }
            if (name.equals("full_name")) {
                fullName = reader.nextString();
                continue;
            }
            if (name.equals("significant_gain")) {
                significantGain = reader.nextDouble();
                continue;
            }
            if (name.equals("significant_loss")) {
                significantLoss = reader.nextDouble();
                continue;
            }
            if (name.equals("insignificant_loss")) {
                insignificantLoss = reader.nextDouble();
                continue;
            }
            if (name.equals("preference")) {
                reader.beginArray();
                categoricalPreference = new ArrayList<String>();
                while (reader.hasNext()) {
                    categoricalPreference.add(reader.nextString());
                }
                reader.endArray();
                continue;
            }
            if (name.equals("range")) {
                if (reader.peek().equals((Object)JsonToken.BEGIN_ARRAY)) {
                    reader.beginArray();
                    categoricalRange = new ArrayList<String>();
                    while (reader.hasNext()) {
                        categoricalRange.add(reader.nextString());
                    }
                    reader.endArray();
                    continue;
                }
                reader.beginObject();
                while (reader.hasNext()) {
                    name = reader.nextName();
                    if (name.equals("low")) {
                        low = reader.nextString();
                        continue;
                    }
                    if (name.equals("high")) {
                        high = reader.nextString();
                        continue;
                    }
                    reader.skipValue();
                }
                reader.endObject();
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        if (type == Column.ColumnType.CATEGORICAL) {
            column = new CategoricalColumn();
            if (categoricalRange != null) {
                ((CategoricalColumn)column).setRange(categoricalRange);
            }
            if (categoricalPreference != null) {
                ((CategoricalColumn)column).setRange(categoricalPreference);
            }
        } else if (type == Column.ColumnType.DATETIME) {
            column = new DateColumn();
            if (low != null) {
                try {
                    ((DateColumn)column).withRange(this.df.parse(low), this.df.parse(high));
                }
                catch (ParseException e) {
                    log.log(Level.SEVERE, "Error parsing the date", e);
                }
            }
        } else if (type == Column.ColumnType.NUMERIC) {
            column = new NumericColumn();
            if (low != null) {
                ((NumericColumn)column).withRange(Double.valueOf(low), Double.valueOf(high));
            }
        } else {
            column = new TextColumn();
        }
        column.setKey(key);
        if (description != null) {
            column.setDescription(description);
        }
        if (format != null) {
            column.setFormat(format);
        }
        if (objective != null) {
            column.setObjective(objective);
        }
        if (fullName != null) {
            column.setFullName(fullName);
        }
        if (goal != null) {
            column.setGoal(goal);
        }
        if (key != null) {
            column.setObjective(objective);
        }
        if (significantGain != null) {
            column.setSignificantGain(significantGain);
        }
        if (significantLoss != null) {
            column.setSignificantLoss(insignificantLoss);
        }
        if (insignificantLoss != null) {
            column.setInsignificantLoss(insignificantLoss);
        }
        return column;
    }

    public void write(JsonWriter writer, Column column) throws IOException {
        writer.beginObject();
        writer.name("key").value(column.getKey());
        writer.name("type").value(column.getType().toString());
        if (column.getGoal() != null) {
            writer.name("goal").value(column.getGoal().toString());
        }
        if (column.isObjective() != null) {
            writer.name("is_objective").value(column.isObjective().booleanValue());
        }
        if (column.getFormat() != null) {
            writer.name("format").value(column.getFormat());
        }
        if (column.getDescription() != null) {
            writer.name("description").value(column.getDescription());
        }
        if (column.getFullName() != null) {
            writer.name("full_name").value(column.getFullName());
        }
        if (column.getSignificantGain() != null) {
            writer.name("significant_gain").value((Number)column.getSignificantGain());
        }
        if (column.getSignificantLoss() != null) {
            writer.name("significant_loss").value((Number)column.getSignificantLoss());
        }
        if (column.getInsignificantLoss() != null) {
            writer.name("insignificant_loss").value((Number)column.getInsignificantLoss());
        }
        Column.ColumnType type = column.getType();
        switch (type) {
            case CATEGORICAL: {
                this.writeCategoricalColumn((CategoricalColumn)column, writer);
                break;
            }
            case NUMERIC: {
                this.writeNumericalColumn((NumericColumn)column, writer);
                break;
            }
            case DATETIME: {
                this.writeDateColumn((DateColumn)column, writer);
                break;
            }
        }
        writer.endObject();
        writer.flush();
    }

    private void writeCategoricalColumn(CategoricalColumn catCol, JsonWriter writer) throws IOException {
        if (catCol.getPreference() != null) {
            writer.name("range");
            writer.beginArray();
            for (String pref : catCol.getPreference()) {
                writer.value(pref);
            }
            writer.endArray();
        }
        if (catCol.getRange() != null) {
            writer.name("range");
            writer.beginArray();
            for (String value : catCol.getRange()) {
                writer.value(value);
            }
            writer.endArray();
        }
    }

    private void writeDateColumn(DateColumn dateCol, JsonWriter writer) throws IOException {
        if (dateCol.getLow() != null) {
            writer.name("range").beginObject();
            writer.name("low").value(this.df.format(dateCol.getLow()));
            writer.name("high").value(this.df.format(dateCol.getHigh()));
            writer.endObject();
        }
    }

    private void writeNumericalColumn(NumericColumn numCol, JsonWriter writer) throws IOException {
        if (numCol.getLow() != null) {
            writer.name("range");
            writer.beginObject();
            writer.name("low").value((Number)numCol.getLow());
            writer.name("high").value((Number)numCol.getHigh());
            writer.endObject();
        }
    }
}

