/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.speech_to_text.v1;

import com.ibm.watson.developer_cloud.service.Request;
import com.ibm.watson.developer_cloud.service.WatsonService;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.SessionStatus;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.SpeechModel;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.SpeechModelSet;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.SpeechResults;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.SpeechSession;
import com.ibm.watson.developer_cloud.util.GsonSingleton;
import com.ibm.watson.developer_cloud.util.ResponseUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.InputStreamEntity;

public class SpeechToText
extends WatsonService {
    public static final String MODEL = "model";
    public static final String INACTIVITY_TIMEOUT = "inactivity_timeout";
    public static final String TIMESTAMPS = "timestamps";
    public static final String MAX_ALTERNATIVES = "max_alternatives";
    public static final String WORD_CONFIDENCE = "word_confidence";
    public static final String CONTINUOUS = "continuous";
    public static final String SESSION_ID = "session_id";
    public static final String CONTENT_TYPE = "content_type";
    public static final String AUDIO = "audio";
    private static final String URL = "https://stream.watsonplatform.net/speech-to-text/api";

    public SpeechToText() {
        this.setEndPoint(URL);
    }

    public SpeechSession createSession() {
        return this.createSession(null);
    }

    public SpeechSession createSession(String model) {
        String path = "/v1/sessions";
        if (model != null && !model.isEmpty()) {
            path = path + "?model=" + model;
        }
        HttpRequestBase request = Request.Post(path, new Object[0]).build();
        try {
            HttpResponse response = this.execute(request);
            SpeechSession speechSession = ResponseUtil.getObject(response, SpeechSession.class);
            speechSession.setCookieSession(response.getFirstHeader("set-cookie").getValue());
            return speechSession;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteSession(SpeechSession session) {
        if (session == null) {
            throw new IllegalArgumentException("session was not specified");
        }
        HttpRequestBase request = Request.Delete("/v1/sessions/" + session.getSessionId(), new Object[0]).withHeader("Cookie", session.getCookieSession()).build();
        HttpResponse response = this.execute(request);
        try {
            ResponseUtil.getString(response);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (response.getStatusLine().getStatusCode() != 204) {
            throw new RuntimeException("Cound't delete session");
        }
    }

    public SpeechModel getModel(SpeechModel watsonModel) {
        return this.getModel(watsonModel.getName());
    }

    public SpeechModel getModel(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name was not specified");
        }
        HttpRequestBase request = Request.Get("/v1/models/" + name, new Object[0]).build();
        try {
            HttpResponse response = this.execute(request);
            return ResponseUtil.getObject(response, SpeechModel.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<SpeechModel> getModels() {
        HttpRequestBase request = Request.Get("/v1/models", new Object[0]).build();
        try {
            HttpResponse response = this.execute(request);
            return ResponseUtil.getObject(response, SpeechModelSet.class).getModels();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public SessionStatus getRecognizeStatus(SpeechSession session) {
        if (session == null) {
            throw new IllegalArgumentException("session was not specified");
        }
        HttpRequestBase request = Request.Get("/v1/sessions/" + session.getSessionId() + "/recognize", new Object[0]).withHeader("Cookie", session.getCookieSession()).build();
        try {
            HttpResponse response = this.execute(request);
            String resultJson = ResponseUtil.getString(response);
            SessionStatus sessionStatus = (SessionStatus)GsonSingleton.getGson().fromJson(resultJson, SessionStatus.class);
            return sessionStatus;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public SpeechResults recognize(File audio, String contentType) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(AUDIO, audio);
        params.put(CONTENT_TYPE, contentType);
        return this.recognize(params);
    }

    public SpeechResults recognize(Map<String, Object> params) {
        String[] queryParameters;
        File audio = (File)params.get(AUDIO);
        if (audio == null || !audio.exists() || !audio.isFile()) {
            throw new IllegalArgumentException("audio is not a valid audio file");
        }
        String contentType = (String)params.get(CONTENT_TYPE);
        if (contentType == null) {
            throw new IllegalArgumentException("contentType was not specified");
        }
        StringBuilder urlBuider = new StringBuilder();
        urlBuider.append("/v1");
        urlBuider.append(params.containsKey(SESSION_ID) ? "/sessions/" + params.get(SESSION_ID) : "");
        urlBuider.append("/recognize");
        Request request = Request.Post(urlBuider.toString(), new Object[0]);
        request.withHeader("Content-Type", contentType);
        for (String param : queryParameters = new String[]{WORD_CONFIDENCE, CONTINUOUS, MAX_ALTERNATIVES, TIMESTAMPS, INACTIVITY_TIMEOUT, MODEL}) {
            if (!params.containsKey(param)) continue;
            request.withQuery(param, params.get(param));
        }
        InputStreamEntity reqEntity = null;
        try {
            reqEntity = new InputStreamEntity((InputStream)new FileInputStream(audio), -1L);
            reqEntity.setContentType(contentType);
            reqEntity.setChunked(true);
            request.withEntity((HttpEntity)reqEntity);
            HttpResponse response = this.execute(request.build());
            return ResponseUtil.getObject(response, SpeechResults.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

