/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.service;

import com.google.gson.JsonObject;
import com.ibm.watson.developer_cloud.service.BadRequestException;
import com.ibm.watson.developer_cloud.service.WatsonService;
import java.net.URI;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;

public abstract class AlchemyService
extends WatsonService {
    private static final String X_ALCHEMY_API_ERROR_MSG = "X-AlchemyAPI-Error-Msg";
    private static final String X_ALCHEMY_API_STATUS = "X-AlchemyAPI-Status";
    private static final String MESSAGE_CODE = "code";
    private static final String MESSAGE_ERROR = "error";
    private static final Logger log = Logger.getLogger(AlchemyService.class.getName());
    private static final String PARAM_APIKEY = "apikey";
    private static final String INVALID_API_KEY = "invalid-api-key";
    private static final String DAILY_TRANSACTION_LIMIT_EXCEEDED = "daily-transaction-limit-exceeded";
    protected static final String ENDPOINT = "https://access.alchemyapi.com/calls";
    protected static final String OUTPUT_MODE = "outputMode";
    protected static final String JSONP = "jsonp";

    @Override
    protected void setAuthentication(HttpRequestBase request) {
        if (this.getApiKey() == null) {
            throw new IllegalArgumentException("apiKey not specified");
        }
        StringBuilder apiKeyToken = new StringBuilder();
        apiKeyToken.append(PARAM_APIKEY).append("=").append(this.getApiKey());
        this.addApiKeyToHttpRequest(request, apiKeyToken.toString());
    }

    private void addApiKeyToHttpRequest(HttpRequestBase request, String apiKey) {
        String query = request.getURI().getQuery();
        if (query == null || query.length() == 0) {
            request.setURI(URI.create(request.getURI() + "?" + apiKey));
        } else {
            request.setURI(URI.create(request.getURI() + "&" + apiKey));
        }
    }

    protected String getInputFormat(Map<String, Object> params, String ... acceptedFormats) {
        int i;
        for (i = 0; i < acceptedFormats.length && params != null && !params.containsKey(acceptedFormats[i]); ++i) {
        }
        if (params == null || i == acceptedFormats.length) {
            throw new IllegalArgumentException(StringUtils.join((Object[])acceptedFormats, (String)",") + " should be specified");
        }
        return acceptedFormats[i];
    }

    public AlchemyService() {
        this.setEndPoint(ENDPOINT);
    }

    private String getErrorMessage(HttpResponse response) {
        Header status = response.getFirstHeader(X_ALCHEMY_API_STATUS);
        Header errorMessage = response.getFirstHeader(X_ALCHEMY_API_ERROR_MSG);
        if (status != null && status.getValue().equals("ERROR")) {
            int code = this.detectErrorCode(errorMessage);
            JsonObject error = new JsonObject();
            error.addProperty(MESSAGE_ERROR, errorMessage != null ? errorMessage.getValue() : "Unknown error");
            error.addProperty(MESSAGE_CODE, (Number)code);
            return error.toString();
        }
        return null;
    }

    private int detectErrorCode(Header errorMessage) {
        String error;
        String string = error = errorMessage != null ? errorMessage.getValue() : null;
        if (error == null) {
            return 400;
        }
        if (error.equals(DAILY_TRANSACTION_LIMIT_EXCEEDED)) {
            return 429;
        }
        if (error.equals(INVALID_API_KEY)) {
            return 401;
        }
        return 400;
    }

    @Override
    protected HttpResponse execute(HttpRequestBase request) {
        HttpResponse response = super.execute(request);
        String error = this.getErrorMessage(response);
        if (error == null) {
            return response;
        }
        log.log(Level.SEVERE, error);
        throw new BadRequestException(error);
    }
}

