/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.natural_language_classifier.v1;

import com.google.gson.JsonObject;
import com.ibm.watson.developer_cloud.natural_language_classifier.v1.model.Classification;
import com.ibm.watson.developer_cloud.natural_language_classifier.v1.model.Classifier;
import com.ibm.watson.developer_cloud.natural_language_classifier.v1.model.Classifiers;
import com.ibm.watson.developer_cloud.natural_language_classifier.v1.model.TrainingData;
import com.ibm.watson.developer_cloud.natural_language_classifier.v1.util.TrainingDataUtils;
import com.ibm.watson.developer_cloud.service.Request;
import com.ibm.watson.developer_cloud.service.WatsonService;
import com.ibm.watson.developer_cloud.util.ResponseUtil;
import java.io.IOException;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;

public class NaturalLanguageClassifier
extends WatsonService {
    public static final String LANGUAGE_EN = "en";
    private static String URL = "https://gateway.watsonplatform.net/natural-language-classifier/api";

    public NaturalLanguageClassifier() {
        this.setEndPoint(URL);
    }

    public Classification classify(String classifierId, String text) {
        if (classifierId == null || classifierId.isEmpty()) {
            throw new IllegalArgumentException("classifierId can not be null or empty");
        }
        if (text == null || text.isEmpty()) {
            throw new IllegalArgumentException("text can not be null or empty");
        }
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("text", text);
        String path = String.format("/v1/classifiers/%s/classify", classifierId);
        HttpRequestBase request = Request.Post(path, new Object[0]).withContent(contentJson).build();
        try {
            HttpResponse response = this.execute(request);
            return ResponseUtil.getObject(response, Classification.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Classifier createClassifier(String name, String language, List<TrainingData> trainingData) {
        if (trainingData == null || trainingData.isEmpty()) {
            throw new IllegalArgumentException("trainingData can not be null or empty");
        }
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("language", language == null ? LANGUAGE_EN : language);
        if (name != null && !name.isEmpty()) {
            contentJson.addProperty("name", name);
        }
        try {
            MultipartEntity reqEntity = new MultipartEntity();
            reqEntity.addPart("training_data", (ContentBody)new StringBody(TrainingDataUtils.toCSV(trainingData.toArray(new TrainingData[0]))));
            reqEntity.addPart("training_metadata", (ContentBody)new StringBody(contentJson.toString()));
            HttpRequestBase request = Request.Post("/v1/classifiers", new Object[0]).withEntity((HttpEntity)reqEntity).build();
            HttpResponse response = this.execute(request);
            return ResponseUtil.getObject(response, Classifier.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteClassifier(String classifierId) {
        if (classifierId == null || classifierId.isEmpty()) {
            throw new IllegalArgumentException("classifierId can not be null or empty");
        }
        HttpRequestBase request = Request.Delete("/v1/classifiers/" + classifierId, new Object[0]).build();
        this.executeWithoutResponse(request);
    }

    public Classifier getClassifier(String classifierId) {
        if (classifierId == null || classifierId.isEmpty()) {
            throw new IllegalArgumentException("classifierId can not be null or empty");
        }
        HttpRequestBase request = Request.Get("/v1/classifiers/" + classifierId, new Object[0]).build();
        try {
            HttpResponse response = this.execute(request);
            return ResponseUtil.getObject(response, Classifier.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Classifiers getClassifiers() {
        HttpRequestBase request = Request.Get("/v1/classifiers", new Object[0]).build();
        try {
            HttpResponse response = this.execute(request);
            return ResponseUtil.getObject(response, Classifiers.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("NaturalLanguageClassifier [getEndPoint()=");
        builder.append(this.getEndPoint());
        builder.append("]");
        return builder.toString();
    }
}

