/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.message_resonance.v1;

import com.ibm.watson.developer_cloud.message_resonance.v1.model.Message;
import com.ibm.watson.developer_cloud.message_resonance.v1.model.MessageResonanceDataset;
import com.ibm.watson.developer_cloud.message_resonance.v1.model.Resonance;
import com.ibm.watson.developer_cloud.service.Request;
import com.ibm.watson.developer_cloud.service.WatsonService;
import com.ibm.watson.developer_cloud.util.GsonSingleton;
import com.ibm.watson.developer_cloud.util.ResponseUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;

public class MessageResonance
extends WatsonService {
    private static final String URL = "https://gateway.watsonplatform.net/message-resonance-beta/api";
    private MessageResonanceDataset dataset;

    public MessageResonance() {
        this.setEndPoint(URL);
    }

    private Message formatResponseMessage(String text, List<Resonance> resonances) {
        Message message = new Message();
        message.setText(text);
        message.setDataset(this.dataset);
        message.setResonances(resonances);
        int index = 0;
        for (Resonance resonance : resonances) {
            resonance.setWordOffset(text.indexOf(resonance.getWord(), index));
            index += resonance.getWord().length();
        }
        return message;
    }

    public MessageResonanceDataset getDataset() {
        return this.dataset;
    }

    public Message getResonance(String text) {
        if (this.dataset == null) {
            throw new IllegalArgumentException("dataset can not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("text can not be null");
        }
        String[] words = text.split("\\s");
        ArrayList<Resonance> resonances = new ArrayList<Resonance>();
        for (String word : words) {
            Resonance resonance = this.getResonanceForWord(word);
            resonances.add(resonance);
        }
        return this.formatResponseMessage(text, resonances);
    }

    private Resonance getResonanceForWord(String word) {
        HttpRequestBase request = Request.Get("/v1/ringscore", new Object[0]).withQuery("text", word, "dataset", this.dataset).build();
        try {
            HttpResponse response = this.execute(request);
            String resonanceJson = ResponseUtil.getString(response);
            return (Resonance)GsonSingleton.getGson().fromJson(resonanceJson, Resonance.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setDataset(MessageResonanceDataset dataset) {
        this.dataset = dataset;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("MessageResonance [dataset=");
        builder.append(this.dataset);
        builder.append(", getEndPoint()=");
        builder.append(this.getEndPoint());
        builder.append("]");
        return builder.toString();
    }
}

