/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.language_translation.v2;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.reflect.TypeToken;
import com.ibm.watson.developer_cloud.language_translation.v2.model.IdentifiableLanguage;
import com.ibm.watson.developer_cloud.language_translation.v2.model.IdentifiedLanguage;
import com.ibm.watson.developer_cloud.language_translation.v2.model.TranslationModel;
import com.ibm.watson.developer_cloud.language_translation.v2.model.TranslationResult;
import com.ibm.watson.developer_cloud.service.Request;
import com.ibm.watson.developer_cloud.service.WatsonService;
import com.ibm.watson.developer_cloud.util.GsonSingleton;
import com.ibm.watson.developer_cloud.util.ResponseUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;

public class LanguageTranslation
extends WatsonService {
    public static final String BASE_MODEL_ID = "base_model_id";
    public static final String FORCED_GLOSSARY = "forced_glossary";
    public static final String DEFAULT = "default";
    public static final String MODEL_ID = "model_id";
    public static final String SOURCE = "source";
    public static final String TARGET = "target";
    public static final String TEXT = "text";
    public static final String NAME = "name";
    private static final String LANGUAGES = "languages";
    private static final String URL = "https://gateway.watsonplatform.net/language-translation/api";
    private final Type identifiableLanguagesListType = new TypeToken<List<IdentifiableLanguage>>(){}.getType();
    private final Type translationModelListType = new TypeToken<List<IdentifiedLanguage>>(){}.getType();
    private final Type modelListType = new TypeToken<List<TranslationModel>>(){}.getType();

    public LanguageTranslation() {
        this.setEndPoint(URL);
    }

    public List<IdentifiableLanguage> getIdentifiableLanguages() {
        Request request = Request.Get("/v2/identifiable_languages", new Object[0]);
        HttpRequestBase requestBase = request.build();
        try {
            HttpResponse response = this.execute(requestBase);
            JsonObject jsonObject = ResponseUtil.getJsonObject(response);
            List langs = (List)GsonSingleton.getGson().fromJson(jsonObject.get(LANGUAGES), this.identifiableLanguagesListType);
            return langs;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<TranslationModel> getModels() {
        return this.getModels(null, null, null);
    }

    public TranslationModel getModel(String modelId) {
        if (modelId == null || modelId.isEmpty()) {
            throw new IllegalArgumentException("model_id can not be null or empty");
        }
        HttpRequestBase request = Request.Get("/v2/models/" + modelId, new Object[0]).build();
        try {
            HttpResponse response = this.execute(request);
            String modelAsString = ResponseUtil.getString(response);
            TranslationModel model = (TranslationModel)GsonSingleton.getGson().fromJson(modelAsString, TranslationModel.class);
            return model;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteModel(String modelId) {
        if (modelId == null || modelId.isEmpty()) {
            throw new IllegalArgumentException("model_id can not be null or empty");
        }
        HttpRequestBase request = Request.Delete("/v2/models/" + modelId, new Object[0]).build();
        this.execute(request);
    }

    public TranslationModel createModel(Map<String, Object> params) {
        File forcedGlossary = (File)params.get(FORCED_GLOSSARY);
        if (forcedGlossary == null || !forcedGlossary.exists() || !forcedGlossary.isFile()) {
            throw new IllegalArgumentException("forced_glossary is not a valid file");
        }
        String baseModelId = (String)params.get(BASE_MODEL_ID);
        if (baseModelId == null || baseModelId.isEmpty()) {
            throw new IllegalArgumentException("base_model_id can not be null or empty");
        }
        Request request = Request.Post("/v2/models", new Object[0]);
        request.withForm(FORCED_GLOSSARY, forcedGlossary);
        request.withForm(BASE_MODEL_ID, baseModelId);
        if (params.containsKey(NAME)) {
            request.withForm(NAME, (String)params.get(NAME));
        }
        HttpRequestBase requestBase = request.build();
        try {
            HttpResponse response = this.execute(requestBase);
            String modelAsString = ResponseUtil.getString(response);
            TranslationModel model = (TranslationModel)GsonSingleton.getGson().fromJson(modelAsString, TranslationModel.class);
            return model;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<TranslationModel> getModels(Boolean showDefault, String source, String target) {
        Request request = Request.Get("/v2/models", new Object[0]);
        if (source != null && !source.isEmpty()) {
            request.withQuery(SOURCE, source);
        }
        if (target != null && !target.isEmpty()) {
            request.withQuery(TARGET, source);
        }
        if (showDefault != null) {
            request.withQuery(DEFAULT, showDefault);
        }
        HttpRequestBase requestBase = request.build();
        try {
            HttpResponse response = this.execute(requestBase);
            JsonObject jsonObject = ResponseUtil.getJsonObject(response);
            List models = (List)GsonSingleton.getGson().fromJson(jsonObject.get("models"), this.modelListType);
            return models;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<IdentifiedLanguage> identify(String text) {
        HttpRequestBase request = Request.Post("/v2/identify", new Object[0]).withContent(text, "text/plain").withHeader("Accept", "application/json").build();
        try {
            HttpResponse response = this.execute(request);
            JsonObject jsonObject = ResponseUtil.getJsonObject(response);
            List identifiedLanguages = (List)GsonSingleton.getGson().fromJson(jsonObject.get(LANGUAGES), this.translationModelListType);
            return identifiedLanguages;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("LanguageTranslation [getEndPoint()=");
        builder.append(this.getEndPoint());
        builder.append("]");
        return builder.toString();
    }

    public TranslationResult translate(Map<String, Object> params) {
        String source = (String)params.get(SOURCE);
        String target = (String)params.get(TARGET);
        String modelId = (String)params.get(MODEL_ID);
        String[] text = params.get(TEXT) != null ? (params.get(TEXT) instanceof String ? new String[]{(String)params.get(TEXT)} : (String[])params.get(TEXT)) : null;
        if ((modelId == null || modelId.isEmpty()) && (source == null || source.isEmpty() || target == null || target.isEmpty())) {
            throw new IllegalArgumentException("model_id or source and target should be specified");
        }
        if (text == null) {
            throw new IllegalArgumentException("text can not be null");
        }
        JsonObject contentJson = new JsonObject();
        JsonArray paragraphs = new JsonArray();
        for (String paragraph : text) {
            paragraphs.add((JsonElement)new JsonPrimitive(paragraph));
        }
        contentJson.add(TEXT, (JsonElement)paragraphs);
        Request requestBuilder = Request.Post("/v2/translate", new Object[0]).withContent(contentJson);
        if (source != null && !source.isEmpty()) {
            requestBuilder.withQuery(SOURCE, source);
        }
        if (target != null && !target.isEmpty()) {
            requestBuilder.withQuery(TARGET, target);
        }
        if (modelId != null && !modelId.isEmpty()) {
            requestBuilder.withQuery(MODEL_ID, modelId);
        }
        HttpRequestBase request = requestBuilder.build();
        try {
            HttpResponse response = this.execute(request);
            String translationResult = ResponseUtil.getString(response);
            TranslationResult translation = (TranslationResult)GsonSingleton.getGson().fromJson(translationResult, TranslationResult.class);
            return translation;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public TranslationResult translate(String text, String modelId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(TEXT, text);
        params.put(MODEL_ID, modelId);
        return this.translate(params);
    }

    public TranslationResult translate(String text, String source, String target) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(TEXT, text);
        params.put(SOURCE, source);
        params.put(TARGET, target);
        return this.translate(params);
    }
}

