/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.document_conversion.v1.helpers;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.Expose;
import com.ibm.watson.developer_cloud.document_conversion.v1.DocumentConversion;
import com.ibm.watson.developer_cloud.document_conversion.v1.helpers.ConversionUtils;
import com.ibm.watson.developer_cloud.document_conversion.v1.model.ConversionTarget;
import com.ibm.watson.developer_cloud.document_conversion.v1.model.Job;
import com.ibm.watson.developer_cloud.document_conversion.v1.model.JobCollection;
import com.ibm.watson.developer_cloud.document_conversion.v1.model.JobResponse;
import com.ibm.watson.developer_cloud.document_conversion.v1.model.JobStatus;
import com.ibm.watson.developer_cloud.service.Request;
import com.ibm.watson.developer_cloud.util.GsonSingleton;
import com.ibm.watson.developer_cloud.util.ResponseUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Map;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;

public class JobHelper {
    @Expose
    private DocumentConversion docConversionService;

    public JobHelper(DocumentConversion docConversionService) {
        this.docConversionService = docConversionService;
    }

    public JobCollection getJobCollection(Map<String, Object> jobListParams) {
        Request request = Request.Get("/v1/jobs", new Object[0]);
        if (jobListParams != null) {
            String status;
            String name;
            String token;
            if (jobListParams.get("token") != null && !(token = (String)jobListParams.get("token")).isEmpty()) {
                request.withQuery("token", token);
            }
            if (jobListParams.get("limit") != null) {
                int limit = (Integer)jobListParams.get("limit");
                if (limit > 0) {
                    request.withQuery("limit", limit);
                } else {
                    request.withQuery("limit", 100);
                }
            }
            if (jobListParams.get("name") != null && !(name = (String)jobListParams.get("name")).isEmpty()) {
                request.withQuery("name", name);
            }
            if (jobListParams.get("since") != null) {
                Date since = (Date)jobListParams.get("since");
                request.withQuery("since", ConversionUtils.convertToISO(since));
            }
            if (jobListParams.get("status") != null && !(status = ((JobStatus)((Object)jobListParams.get("status"))).toString()).isEmpty()) {
                request.withQuery("status", status);
            }
        }
        HttpRequestBase requestBase = request.build();
        try {
            HttpResponse response = this.docConversionService.execute(requestBase);
            String JobsAsJson = ResponseUtil.getString(response);
            JobCollection jobs = (JobCollection)GsonSingleton.getGson().fromJson(JobsAsJson, JobCollection.class);
            return jobs;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public JobResponse createJob(String name, String batchId, ConversionTarget conversionTarget, JsonObject config) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("name can not be null or empty");
        }
        if (batchId == null || batchId.isEmpty()) {
            throw new IllegalArgumentException("batch id can not be null or empty");
        }
        if (conversionTarget == null) {
            throw new IllegalArgumentException("conversion target can not be null");
        }
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("name", name);
        contentJson.addProperty("batch_id", batchId);
        contentJson.addProperty("conversion_target", conversionTarget.toString());
        if (config != null) {
            contentJson.add("config", (JsonElement)config);
        }
        HttpRequestBase request = Request.Post("/v1/jobs", new Object[0]).withContent(contentJson).build();
        try {
            HttpResponse response = this.docConversionService.execute(request);
            String JobAsJson = ResponseUtil.getString(response);
            JobResponse job = (JobResponse)GsonSingleton.getGson().fromJson(JobAsJson, JobResponse.class);
            return job;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Job getJob(String jobId) {
        if (jobId == null || jobId.isEmpty()) {
            throw new IllegalArgumentException("job id can not be null or empty");
        }
        HttpRequestBase request = Request.Get("/v1/jobs/" + jobId, new Object[0]).build();
        try {
            HttpResponse response = this.docConversionService.execute(request);
            String JobAsJson = ResponseUtil.getString(response);
            Job job = (Job)GsonSingleton.getGson().fromJson(JobAsJson, Job.class);
            return job;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public InputStream getJobLog(String jobId) {
        if (jobId == null || jobId.isEmpty()) {
            throw new IllegalArgumentException("job id can not be null or empty");
        }
        HttpRequestBase request = Request.Get("/v1/jobs/" + jobId + "/log", new Object[0]).withHeader("Accept", "text/plain").build();
        try {
            HttpResponse response = this.docConversionService.execute(request);
            InputStream is = ResponseUtil.getInputStream(response);
            return is;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

