/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.document_conversion.v1.helpers;

import com.google.gson.JsonObject;
import com.google.gson.annotations.Expose;
import com.ibm.watson.developer_cloud.document_conversion.v1.DocumentConversion;
import com.ibm.watson.developer_cloud.document_conversion.v1.helpers.ConversionUtils;
import com.ibm.watson.developer_cloud.document_conversion.v1.model.Answers;
import com.ibm.watson.developer_cloud.document_conversion.v1.model.ConversionTarget;
import com.ibm.watson.developer_cloud.service.Request;
import com.ibm.watson.developer_cloud.util.GsonSingleton;
import com.ibm.watson.developer_cloud.util.ResponseUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;

public class ConvertDocumentHelper {
    @Expose
    private DocumentConversion docConversionService;

    public ConvertDocumentHelper(DocumentConversion docConversionService) {
        this.docConversionService = docConversionService;
    }

    public Answers convertDocumentToAnswer(File document) {
        InputStream is = this.convertDocument(document, ConversionTarget.ANSWER_UNITS);
        String convertedDocument = ConversionUtils.writeInputStreamToString(is);
        Answers answers = (Answers)GsonSingleton.getGson().fromJson(convertedDocument, Answers.class);
        return answers;
    }

    public InputStream convertDocument(File document, ConversionTarget conversionTarget) {
        String mediaType = ConversionUtils.getMediaTypeFromFile(document);
        return this.convertDocument(document, mediaType, conversionTarget);
    }

    public InputStream convertDocument(File document, String mediaType, ConversionTarget conversionTarget) {
        if (mediaType == null || mediaType.isEmpty()) {
            throw new IllegalArgumentException("media type cannot be null or empty");
        }
        if (!ConversionUtils.isValidMediaType(mediaType).booleanValue()) {
            throw new IllegalArgumentException("file with the given media type is not supported");
        }
        if (document == null || !document.exists()) {
            throw new IllegalArgumentException("document can not be null and must exist");
        }
        if (conversionTarget == null) {
            throw new IllegalArgumentException("conversion target can not be null");
        }
        try {
            MultipartEntity reqEntity = new MultipartEntity();
            reqEntity.addPart("file", (ContentBody)new FileBody(document, mediaType));
            JsonObject configRequestJson = new JsonObject();
            configRequestJson.addProperty("conversion_target", conversionTarget.toString());
            String json = configRequestJson.toString();
            reqEntity.addPart("config", (ContentBody)new StringBody(json, "application/json", Charset.forName("UTF-8")));
            HttpRequestBase request = Request.Post("/v1/convert_document", new Object[0]).withEntity((HttpEntity)reqEntity).build();
            HttpResponse response = this.docConversionService.execute(request);
            InputStream is = ResponseUtil.getInputStream(response);
            return is;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Answers convertDocumentToAnswer(String documentId) {
        InputStream is = this.convertDocument(documentId, ConversionTarget.ANSWER_UNITS);
        String convertedDocument = ConversionUtils.writeInputStreamToString(is);
        Answers answers = (Answers)GsonSingleton.getGson().fromJson(convertedDocument, Answers.class);
        return answers;
    }

    public InputStream convertDocument(String documentId, ConversionTarget conversionTarget) {
        if (documentId == null || documentId.isEmpty()) {
            throw new IllegalArgumentException("document id can not be null or empty");
        }
        if (conversionTarget == null) {
            throw new IllegalArgumentException("conversion target can not be null");
        }
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("document_id", documentId);
        contentJson.addProperty("conversion_target", conversionTarget.toString());
        HttpRequestBase request = Request.Post("/v1/convert_document", new Object[0]).withContent(contentJson).build();
        try {
            HttpResponse response = this.docConversionService.execute(request);
            InputStream is = ResponseUtil.getInputStream(response);
            return is;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

