/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.document_conversion.v1.helpers;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.annotations.Expose;
import com.ibm.watson.developer_cloud.document_conversion.v1.DocumentConversion;
import com.ibm.watson.developer_cloud.document_conversion.v1.helpers.ConversionUtils;
import com.ibm.watson.developer_cloud.document_conversion.v1.model.Batch;
import com.ibm.watson.developer_cloud.document_conversion.v1.model.BatchCollection;
import com.ibm.watson.developer_cloud.document_conversion.v1.model.Property;
import com.ibm.watson.developer_cloud.service.Request;
import com.ibm.watson.developer_cloud.util.GsonSingleton;
import com.ibm.watson.developer_cloud.util.ResponseUtil;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;

public class BatchHelper {
    @Expose
    private DocumentConversion docConversionService;

    public BatchHelper(DocumentConversion docConversionService) {
        this.docConversionService = docConversionService;
    }

    public Batch createBatch(String name, List<Property> properties) {
        JsonObject contentJson = new JsonObject();
        if (name != null && !name.isEmpty()) {
            contentJson.addProperty("name", name);
        }
        if (properties != null && !properties.isEmpty()) {
            contentJson.addProperty("properties", new Gson().toJson(properties));
        }
        HttpRequestBase request = Request.Post("/v1/batches", new Object[0]).withContent(this.filterJson(contentJson), "application/json").build();
        try {
            HttpResponse response = this.docConversionService.execute(request);
            String batchAsJson = ResponseUtil.getString(response);
            Batch batch = (Batch)GsonSingleton.getGson().fromJson(batchAsJson, Batch.class);
            return batch;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public BatchCollection getBatchCollection(Map<String, Object> batchListParams) {
        Request request = Request.Get("/v1/batches", new Object[0]);
        if (batchListParams != null) {
            String name;
            String token;
            if (batchListParams.get("token") != null && !(token = (String)batchListParams.get("token")).isEmpty()) {
                request.withQuery("token", token);
            }
            if (batchListParams.get("limit") != null) {
                int limit = (Integer)batchListParams.get("limit");
                if (limit > 0) {
                    request.withQuery("limit", limit);
                } else {
                    request.withQuery("limit", 100);
                }
            }
            if (batchListParams.get("name") != null && !(name = (String)batchListParams.get("name")).isEmpty()) {
                request.withQuery("name", name);
            }
            if (batchListParams.get("since") != null) {
                Date since = (Date)batchListParams.get("since");
                request.withQuery("since", ConversionUtils.convertToISO(since));
            }
        }
        HttpRequestBase requestBase = request.build();
        try {
            HttpResponse response = this.docConversionService.execute(requestBase);
            String batchCollectionAsJson = ResponseUtil.getString(response);
            BatchCollection batchCollection = (BatchCollection)GsonSingleton.getGson().fromJson(batchCollectionAsJson, BatchCollection.class);
            return batchCollection;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Batch getBatch(String batchId) {
        if (batchId == null || batchId.isEmpty()) {
            throw new IllegalArgumentException("batchId can not be null or empty");
        }
        HttpRequestBase request = Request.Get("/v1/batches/" + batchId, new Object[0]).build();
        try {
            HttpResponse response = this.docConversionService.execute(request);
            String batchAsJson = ResponseUtil.getString(response);
            Batch batch = (Batch)GsonSingleton.getGson().fromJson(batchAsJson, Batch.class);
            return batch;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Batch updateBatch(String batchId, String name, List<Property> properties) {
        if (batchId == null || batchId.isEmpty()) {
            throw new IllegalArgumentException("batchId cannot be null or empty");
        }
        JsonObject contentJson = new JsonObject();
        if (name != null && !name.isEmpty()) {
            contentJson.addProperty("name", name);
        }
        if (properties != null && properties.isEmpty()) {
            contentJson.addProperty("properties", new Gson().toJson(properties));
        }
        HttpRequestBase request = Request.Put("/v1/batches/" + batchId, new Object[0]).withContent(this.filterJson(contentJson), "application/json").build();
        try {
            HttpResponse response = this.docConversionService.execute(request);
            String batchAsJson = ResponseUtil.getString(response);
            Batch batch = (Batch)GsonSingleton.getGson().fromJson(batchAsJson, Batch.class);
            return batch;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String filterJson(JsonObject jsonObject) {
        return jsonObject.toString().replace("\\", "").replace("\"[", "[").replaceAll("]\"", "]");
    }
}

