/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.document_conversion.v1.helpers;

import com.google.gson.annotations.Expose;
import com.ibm.watson.developer_cloud.document_conversion.v1.DocumentConversion;
import com.ibm.watson.developer_cloud.document_conversion.v1.helpers.ConversionUtils;
import com.ibm.watson.developer_cloud.document_conversion.v1.model.BatchDocumentCollection;
import com.ibm.watson.developer_cloud.document_conversion.v1.model.BatchDocumentResponse;
import com.ibm.watson.developer_cloud.service.Request;
import com.ibm.watson.developer_cloud.util.GsonSingleton;
import com.ibm.watson.developer_cloud.util.ResponseUtil;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;

public class BatchDocumentHelper {
    @Expose
    private DocumentConversion docConversionService;

    public BatchDocumentHelper(DocumentConversion docConversionService) {
        this.docConversionService = docConversionService;
    }

    public BatchDocumentResponse addDocumentToBatch(String batchId, String documentId) {
        if (batchId == null || batchId.isEmpty()) {
            throw new IllegalArgumentException("batchId cannot be null or empty");
        }
        if (documentId == null || documentId.isEmpty()) {
            throw new IllegalArgumentException("documentId cannot be null or empty");
        }
        HttpRequestBase request = Request.Put("/v1/batches/" + batchId + "/documents/" + documentId, new Object[0]).build();
        try {
            HttpResponse response = this.docConversionService.execute(request);
            String batchDocumentAsJson = ResponseUtil.getString(response);
            BatchDocumentResponse batchDocumentResponse = (BatchDocumentResponse)GsonSingleton.getGson().fromJson(batchDocumentAsJson, BatchDocumentResponse.class);
            return batchDocumentResponse;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public BatchDocumentCollection getBatchDocumentCollection(String batchId, Map<String, Object> batchDocListParams) {
        if (batchId == null || batchId.isEmpty()) {
            throw new IllegalArgumentException("batchId cannot be null or empty");
        }
        Request request = Request.Get("/v1/batches/" + batchId + "/documents", new Object[0]);
        if (batchDocListParams != null) {
            String token;
            if (batchDocListParams.get("token") != null && !(token = (String)batchDocListParams.get("token")).isEmpty()) {
                request.withQuery("token", token);
            }
            if (batchDocListParams.get("limit") != null) {
                int limit = (Integer)batchDocListParams.get("limit");
                if (limit > 0) {
                    request.withQuery("limit", limit);
                } else {
                    request.withQuery("limit", 100);
                }
            }
            if (batchDocListParams.get("since") != null) {
                Date since = (Date)batchDocListParams.get("since");
                request.withQuery("since", ConversionUtils.convertToISO(since));
            }
        }
        HttpRequestBase requestBase = request.build();
        try {
            HttpResponse response = this.docConversionService.execute(requestBase);
            String batchDocumentCollectionAsJson = ResponseUtil.getString(response);
            BatchDocumentCollection batchDocumentCollection = (BatchDocumentCollection)GsonSingleton.getGson().fromJson(batchDocumentCollectionAsJson, BatchDocumentCollection.class);
            return batchDocumentCollection;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public BatchDocumentResponse getBatchDocument(String batchId, String documentId) {
        if (batchId == null || batchId.isEmpty()) {
            throw new IllegalArgumentException("batchId cannot be null or empty");
        }
        if (documentId == null || documentId.isEmpty()) {
            throw new IllegalArgumentException("documentId cannot be null or empty");
        }
        HttpRequestBase request = Request.Get("/v1/batches/" + batchId + "/documents/" + documentId, new Object[0]).build();
        try {
            HttpResponse response = this.docConversionService.execute(request);
            String batchDocumentAsJson = ResponseUtil.getString(response);
            BatchDocumentResponse batchDocumentResponse = (BatchDocumentResponse)GsonSingleton.getGson().fromJson(batchDocumentAsJson, BatchDocumentResponse.class);
            return batchDocumentResponse;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

