/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.document_conversion.v1;

import com.google.gson.JsonObject;
import com.ibm.watson.developer_cloud.document_conversion.v1.helpers.BatchDocumentHelper;
import com.ibm.watson.developer_cloud.document_conversion.v1.helpers.BatchHelper;
import com.ibm.watson.developer_cloud.document_conversion.v1.helpers.ConvertDocumentHelper;
import com.ibm.watson.developer_cloud.document_conversion.v1.helpers.DocumentHelper;
import com.ibm.watson.developer_cloud.document_conversion.v1.helpers.JobHelper;
import com.ibm.watson.developer_cloud.document_conversion.v1.helpers.OutputHelper;
import com.ibm.watson.developer_cloud.document_conversion.v1.model.Answers;
import com.ibm.watson.developer_cloud.document_conversion.v1.model.Batch;
import com.ibm.watson.developer_cloud.document_conversion.v1.model.BatchCollection;
import com.ibm.watson.developer_cloud.document_conversion.v1.model.BatchDocumentCollection;
import com.ibm.watson.developer_cloud.document_conversion.v1.model.BatchDocumentResponse;
import com.ibm.watson.developer_cloud.document_conversion.v1.model.ConversionTarget;
import com.ibm.watson.developer_cloud.document_conversion.v1.model.Document;
import com.ibm.watson.developer_cloud.document_conversion.v1.model.DocumentCollection;
import com.ibm.watson.developer_cloud.document_conversion.v1.model.Job;
import com.ibm.watson.developer_cloud.document_conversion.v1.model.JobCollection;
import com.ibm.watson.developer_cloud.document_conversion.v1.model.JobResponse;
import com.ibm.watson.developer_cloud.document_conversion.v1.model.OutputCollection;
import com.ibm.watson.developer_cloud.document_conversion.v1.model.Property;
import com.ibm.watson.developer_cloud.service.WatsonService;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;

public class DocumentConversion
extends WatsonService {
    public static final int DEFAULT_LIMIT = 100;
    public static final String JOB_ID = "job_id";
    public static final String LIMIT = "limit";
    public static final String MEDIA_TYPE = "media_type";
    public static final String NAME = "name";
    public static final String SINCE = "since";
    public static final String STATUS = "status";
    public static final String TOKEN = "token";
    private static final String URL = "https://gateway.watsonplatform.net/document-conversion-experimental/api";
    private final BatchDocumentHelper batchDocumentHelper;
    private final BatchHelper batchHelper;
    private final ConvertDocumentHelper convertDocumentHelper;
    private final DocumentHelper documentHelper;
    private final JobHelper jobHelper;
    private final OutputHelper outputHelper;

    public DocumentConversion() {
        this.setEndPoint(URL);
        this.batchHelper = new BatchHelper(this);
        this.documentHelper = new DocumentHelper(this);
        this.batchDocumentHelper = new BatchDocumentHelper(this);
        this.jobHelper = new JobHelper(this);
        this.outputHelper = new OutputHelper(this);
        this.convertDocumentHelper = new ConvertDocumentHelper(this);
    }

    public BatchDocumentResponse addDocumentToBatch(String batchId, String documentId) {
        return this.batchDocumentHelper.addDocumentToBatch(batchId, documentId);
    }

    public InputStream convertDocument(File document, ConversionTarget conversionTarget) {
        return this.convertDocumentHelper.convertDocument(document, conversionTarget);
    }

    public InputStream convertDocument(File document, String mediaType, ConversionTarget conversionTarget) {
        return this.convertDocumentHelper.convertDocument(document, mediaType, conversionTarget);
    }

    public InputStream convertDocument(String documentId, ConversionTarget conversionTarget) {
        return this.convertDocumentHelper.convertDocument(documentId, conversionTarget);
    }

    public Answers convertDocumentToAnswer(File document) {
        return this.convertDocumentHelper.convertDocumentToAnswer(document);
    }

    public Answers convertDocumentToAnswer(String documentId) {
        return this.convertDocumentHelper.convertDocumentToAnswer(documentId);
    }

    public Batch createBatch(String name, List<Property> properties) {
        return this.batchHelper.createBatch(name, properties);
    }

    public JobResponse createJob(String name, String batchId, ConversionTarget conversionTarget) {
        return this.createJob(name, batchId, conversionTarget, null);
    }

    public JobResponse createJob(String name, String batchId, ConversionTarget conversionTarget, JsonObject config) {
        return this.jobHelper.createJob(name, batchId, conversionTarget, config);
    }

    @Override
    public HttpResponse execute(HttpRequestBase request) {
        return super.execute(request);
    }

    public Batch getBatch(String batchId) {
        return this.batchHelper.getBatch(batchId);
    }

    public BatchCollection getBatchCollection() {
        return this.getBatchCollection(null);
    }

    public BatchCollection getBatchCollection(Map<String, Object> batchListParams) {
        return this.batchHelper.getBatchCollection(batchListParams);
    }

    public BatchDocumentResponse getBatchDocument(String batchId, String documentId) {
        return this.batchDocumentHelper.getBatchDocument(batchId, documentId);
    }

    public BatchDocumentCollection getBatchDocumentCollection(String batchId) {
        return this.getBatchDocumentCollection(batchId, null);
    }

    public BatchDocumentCollection getBatchDocumentCollection(String batchId, Map<String, Object> batchDocListParams) {
        return this.batchDocumentHelper.getBatchDocumentCollection(batchId, batchDocListParams);
    }

    public InputStream getDocument(String documentId) {
        return this.documentHelper.getDocument(documentId);
    }

    public DocumentCollection getDocumentCollection() {
        return this.getDocumentCollection(null);
    }

    public DocumentCollection getDocumentCollection(Map<String, Object> docListParams) {
        return this.documentHelper.getDocumentCollection(docListParams);
    }

    public Job getJob(String jobId) {
        return this.jobHelper.getJob(jobId);
    }

    public JobCollection getJobCollection() {
        return this.getJobCollection(null);
    }

    public JobCollection getJobCollection(Map<String, Object> jobListParams) {
        return this.jobHelper.getJobCollection(jobListParams);
    }

    public InputStream getJobLog(String jobId) {
        return this.jobHelper.getJobLog(jobId);
    }

    public InputStream getOutput(String outputId) {
        return this.outputHelper.getOutput(outputId);
    }

    public OutputCollection getOutputCollection() {
        return this.getOutputCollection(null);
    }

    public OutputCollection getOutputCollection(Map<String, Object> outputListParams) {
        return this.outputHelper.getOutputCollection(outputListParams);
    }

    public Batch updateBatch(String batchId, String name, List<Property> properties) {
        return this.batchHelper.updateBatch(batchId, name, properties);
    }

    public Document uploadDocument(File document) {
        return this.documentHelper.uploadDocument(document);
    }

    public Document uploadDocument(File document, String mediaType) {
        return this.documentHelper.uploadDocument(document, mediaType);
    }
}

