/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.alchemy.v1.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AlchemyEndPoints {
    private static final Logger log = Logger.getLogger(AlchemyEndPoints.class.getName());
    private static final String filePath = "/alchemy_endpoints.json";
    private static Map<String, Map<String, String>> operations;

    private static void loadEndPointsFromJsonFile() {
        log.log(Level.FINE, "Parsing End Points JSON file ");
        operations = new HashMap<String, Map<String, String>>();
        JsonParser parser = new JsonParser();
        try {
            InputStreamReader fileReader = null;
            InputStream is = AlchemyEndPoints.class.getResourceAsStream(filePath);
            if (null != is) {
                fileReader = new InputStreamReader(is);
            }
            JsonElement obj = parser.parse(fileReader);
            JsonObject jsonObject = (JsonObject)obj;
            for (AlchemyAPI object : AlchemyAPI.values()) {
                JsonObject elt;
                if (jsonObject.get(object.name()) == null || !(elt = jsonObject.get(object.name()).getAsJsonObject()).isJsonObject()) continue;
                HashMap records = new HashMap();
                for (Map.Entry e : elt.getAsJsonObject().entrySet()) {
                    records.put(e.getKey(), ((JsonElement)e.getValue()).getAsString());
                }
                operations.put(object.name(), records);
            }
        }
        catch (JsonParseException e) {
            log.log(Level.SEVERE, "Could not parse json file: /alchemy_endpoints.json", e);
        }
        catch (NullPointerException e) {
            log.log(Level.SEVERE, "Not able to locate the end points json file: /alchemy_endpoints.json", e);
        }
    }

    public static String getPath(AlchemyAPI operation, String inputType) {
        if (operations.get(operation.name()) != null && operations.get(operation.name()).get(inputType) != null) {
            return operations.get(operation.name()).get(inputType);
        }
        String error = "Operation: " + (Object)((Object)operation) + ", inputType: " + inputType + " not found";
        log.log(Level.SEVERE, error);
        throw new IllegalArgumentException(error);
    }

    static {
        AlchemyEndPoints.loadEndPointsFromJsonFile();
    }

    public static enum AlchemyAPI {
        entities,
        keywords,
        concepts,
        sentiment,
        sentiment_targeted,
        relations,
        language,
        text,
        text_raw,
        authors,
        feeds,
        microformats,
        title,
        taxonomy,
        combined,
        image_link,
        image_keywords,
        image_recognition;

    }
}

