/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.alchemy.v1;

import com.ibm.watson.developer_cloud.alchemy.v1.model.ImageFaces;
import com.ibm.watson.developer_cloud.alchemy.v1.model.ImageKeywords;
import com.ibm.watson.developer_cloud.alchemy.v1.model.ImageLink;
import com.ibm.watson.developer_cloud.alchemy.v1.util.AlchemyEndPoints;
import com.ibm.watson.developer_cloud.service.AlchemyService;
import com.ibm.watson.developer_cloud.service.Request;
import com.ibm.watson.developer_cloud.util.ResponseUtil;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.FileEntity;

public class AlchemyVision
extends AlchemyService {
    public static final String FORCE_SHOW_ALL = "forceShowAll";
    public static final String KNOWLEDGE_GRAPH = "knowledgeGraph";
    public static final String IMAGE_POST_MODE = "imagePostMode";
    public static final String RAW = "raw";
    public static final String NOT_RAW = "not-raw";
    public static final String IMAGE = "image";
    public static final String URL = "url";
    public static final String HTML = "html";

    public ImageLink getImageLink(Map<String, Object> params) {
        String inputType = this.getInputFormat(params, HTML, URL);
        String path = AlchemyEndPoints.getPath(AlchemyEndPoints.AlchemyAPI.image_link, inputType);
        params.put("outputMode", "json");
        Request request = Request.Post(path, new Object[0]);
        for (String param : params.keySet()) {
            request.withForm(param, params.get(param));
        }
        HttpRequestBase requestBase = request.build();
        try {
            HttpResponse response = this.execute(requestBase);
            return ResponseUtil.getObject(response, ImageLink.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ImageKeywords getImageKeywords(Map<String, Object> params) {
        return this.executeRequest(params, AlchemyEndPoints.AlchemyAPI.image_keywords, ImageKeywords.class);
    }

    public ImageFaces recognizeFaces(Map<String, Object> params) {
        return this.executeRequest(params, AlchemyEndPoints.AlchemyAPI.image_recognition, ImageFaces.class);
    }

    private <T> T executeRequest(Map<String, Object> params, AlchemyEndPoints.AlchemyAPI operation, Class<T> returnType) {
        String inputType = this.getInputFormat(params, IMAGE, URL);
        String path = AlchemyEndPoints.getPath(operation, inputType);
        Request request = Request.Post(path, new Object[0]);
        if (inputType == IMAGE) {
            if (params.get(IMAGE) instanceof String) {
                params.put(IMAGE_POST_MODE, NOT_RAW);
            } else {
                params.put(IMAGE_POST_MODE, RAW);
                File image = (File)params.get(IMAGE);
                if (!image.exists()) {
                    throw new IllegalArgumentException("The file: " + image.getAbsolutePath() + " does not exist.");
                }
                request.withEntity((HttpEntity)new FileEntity((File)params.get(IMAGE), "application/octet-stream"));
                params.remove(IMAGE);
            }
        }
        params.put("outputMode", "json");
        for (String param : params.keySet()) {
            if (inputType.equals(IMAGE)) {
                request.withQuery(param, params.get(param));
                continue;
            }
            request.withForm(param, params.get(param));
        }
        HttpRequestBase requestBase = request.build();
        try {
            HttpResponse response = this.execute(requestBase);
            return ResponseUtil.getObject(response, returnType);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

