/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.alchemy.v1;

import com.ibm.watson.developer_cloud.alchemy.v1.model.CombinedResults;
import com.ibm.watson.developer_cloud.alchemy.v1.model.DocumentAuthors;
import com.ibm.watson.developer_cloud.alchemy.v1.model.DocumentSentiment;
import com.ibm.watson.developer_cloud.alchemy.v1.model.DocumentText;
import com.ibm.watson.developer_cloud.alchemy.v1.model.DocumentTitle;
import com.ibm.watson.developer_cloud.alchemy.v1.model.Entities;
import com.ibm.watson.developer_cloud.alchemy.v1.model.Feeds;
import com.ibm.watson.developer_cloud.alchemy.v1.model.Keywords;
import com.ibm.watson.developer_cloud.alchemy.v1.model.Language;
import com.ibm.watson.developer_cloud.alchemy.v1.model.Microformats;
import com.ibm.watson.developer_cloud.alchemy.v1.model.SAORelations;
import com.ibm.watson.developer_cloud.alchemy.v1.model.Taxonomies;
import com.ibm.watson.developer_cloud.alchemy.v1.util.AlchemyEndPoints;
import com.ibm.watson.developer_cloud.service.AlchemyService;
import com.ibm.watson.developer_cloud.service.Request;
import com.ibm.watson.developer_cloud.util.ResponseUtil;
import java.io.IOException;
import java.util.Map;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;

public class AlchemyLanguage
extends AlchemyService {
    public static final String BASE_URL = "baseUrl";
    public static final String COREFERENCE = "coreference";
    public static final String CQUERY = "cquery";
    public static final String DISAMBIGUTE = "disambiguate";
    public static final String ENTITIES = "entities";
    public static final String EXTRACT = "extract";
    public static final String EXTRACT_LINK = "extractLinks";
    public static final String FORCED_GLOSSARY = "forced_glossary";
    public static final String HTML = "html";
    public static final String KEYWORD_EXTRACT_MODE = "keywordExtractMode";
    public static final String KEYWORDS = "keywords";
    public static final String KNOWLEDGE_GRAPH = "knowledgeGraph";
    public static final String LINKED_DATA = "linkedData";
    public static final String MAX_RETRIEVE = "maxRetrieve";
    public static final String QUOTATIONS = "quotations";
    public static final String RAW = "raw";
    public static final String REQUIRED_ENTITIES = "requireEntities";
    public static final String SENTIMENT = "sentiment";
    public static final String SENTIMENT_EXCLUDE_ENTITIES = "sentimentExcludeEntities";
    public static final String SHOW_SOURCE_TEXT = "showSourceText";
    public static final String SOURCE_TEXT = "sourceText";
    public static final String STRUCTURED_ENTITIES = "structuredEntities";
    public static final String TARGET = "target";
    public static final String TEXT = "text";
    public static final String URL = "url";
    public static final String USE_METADATA = "useMetadata";
    public static final String XPATH = "xpath";

    private <T> T executeRequest(Map<String, Object> params, AlchemyEndPoints.AlchemyAPI operation, Class<T> returnType, String ... acceptedFormats) {
        String format = this.getInputFormat(params, acceptedFormats);
        String path = AlchemyEndPoints.getPath(operation, format);
        params.put("outputMode", "json");
        params.remove("jsonp");
        Request request = Request.Post(path, new Object[0]);
        for (String param : params.keySet()) {
            request.withForm(param, params.get(param));
        }
        HttpRequestBase requestBase = request.build();
        try {
            HttpResponse response = this.execute(requestBase);
            return ResponseUtil.getObject(response, returnType);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public DocumentAuthors getAuthors(Map<String, Object> params) {
        return this.executeRequest(params, AlchemyEndPoints.AlchemyAPI.authors, DocumentAuthors.class, HTML, URL);
    }

    public Taxonomies geTaxonomy(Map<String, Object> params) {
        return this.executeRequest(params, AlchemyEndPoints.AlchemyAPI.taxonomy, Taxonomies.class, TEXT, HTML, URL);
    }

    public CombinedResults getCombinedResults(Map<String, Object> params) {
        return this.executeRequest(params, AlchemyEndPoints.AlchemyAPI.combined, CombinedResults.class, TEXT, HTML, URL);
    }

    public Entities getEntities(Map<String, Object> params) {
        return this.executeRequest(params, AlchemyEndPoints.AlchemyAPI.entities, Entities.class, TEXT, HTML, URL);
    }

    public Feeds getFeeds(Map<String, Object> params) {
        return this.executeRequest(params, AlchemyEndPoints.AlchemyAPI.feeds, Feeds.class, HTML, URL);
    }

    public Keywords getKeywords(Map<String, Object> params) {
        return this.executeRequest(params, AlchemyEndPoints.AlchemyAPI.keywords, Keywords.class, TEXT, HTML, URL);
    }

    public Language getLanguage(Map<String, Object> params) {
        return this.executeRequest(params, AlchemyEndPoints.AlchemyAPI.language, Language.class, TEXT, HTML, URL);
    }

    public Microformats getMicroformats(Map<String, Object> params) {
        return this.executeRequest(params, AlchemyEndPoints.AlchemyAPI.microformats, Microformats.class, HTML, URL);
    }

    public SAORelations getRelations(Map<String, Object> params) {
        return this.executeRequest(params, AlchemyEndPoints.AlchemyAPI.relations, SAORelations.class, TEXT, HTML, URL);
    }

    public DocumentSentiment getSentiment(Map<String, Object> params) {
        AlchemyEndPoints.AlchemyAPI operation = AlchemyEndPoints.AlchemyAPI.sentiment;
        if (params.get(TARGET) != null) {
            operation = AlchemyEndPoints.AlchemyAPI.sentiment_targeted;
        }
        return this.executeRequest(params, operation, DocumentSentiment.class, TEXT, HTML, URL);
    }

    public DocumentText getText(Map<String, Object> params) {
        AlchemyEndPoints.AlchemyAPI operation = AlchemyEndPoints.AlchemyAPI.text;
        if (params.get(RAW) != null) {
            operation = AlchemyEndPoints.AlchemyAPI.text_raw;
        }
        return this.executeRequest(params, operation, DocumentText.class, HTML, URL);
    }

    public DocumentTitle getTitle(Map<String, Object> params) {
        return this.executeRequest(params, AlchemyEndPoints.AlchemyAPI.title, DocumentTitle.class, HTML, URL);
    }
}

