/**
 * Copyright 2015 IBM Corp. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ibm.watson.developer_cloud.document_conversion.v1.model;

import com.google.gson.annotations.Expose;
import com.ibm.watson.developer_cloud.document_conversion.v1.DocumentConversion;
import com.ibm.watson.developer_cloud.service.model.GenericModel;

/**
 * Structure that holds the links generated by the Document Conversion service.
 * Can include self links (to access the resource itself) or links for paging
 *
 * @see DocumentConversion
 */
public class Link extends GenericModel {

    /** The name of the link. */
    @Expose
    private String name;

    /** The link to the document. */
    @Expose
    private String link;

    /**
     * Returns the name of the link.
     *
     * @return the name
     */
    public String getName() {
        return name;
    }

    /**
     * Sets the name of the link.
     *
     * @param name the new name
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * Returns the link to the document.
     *
     * @return the link
     */
    public String getLink() {
        return link;
    }

    /**
     * Sets the link to the document.
     *
     * @param link the new link
     */
    public void setLink(String link) {
        this.link = link;
    }

}
