/**
 * Copyright 2015 IBM Corp. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ibm.watson.developer_cloud.document_conversion.v1.helpers;

import com.ibm.watson.developer_cloud.document_conversion.v1.DocumentConversion;

/**
 * The constants class for DocumentConversion service helpers
 *
 * @see DocumentConversion
 */
class ConfigConstants {

    /**
     * The BATCHES_PATH.  (value is "/v1/batches")
     **/
    static final String BATCHES_PATH = "/v1/batches";

    /**
     * The CONVERT_DOCUMENT_PATH.  (value is "/v1/convert_document")
     **/
    static final String CONVERT_DOCUMENT_PATH = "/v1/convert_document";

    /**
     * The DOCUMENTS_PATH.  (value is "/v1/documents")
     **/
    static final String DOCUMENTS_PATH = "/v1/documents";

    /**
     * The JOBS_PATH.  (value is "/v1/jobs")
     **/
    static final String JOBS_PATH = "/v1/jobs";

    /**
     * The OUTPUT_PATH.  (value is "/v1/output")
     **/
    static final String OUTPUT_PATH = "/v1/output";

}
