/**
 * Copyright 2015 IBM Corp. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ibm.watson.developer_cloud.concept_insights.v2.model;

import java.util.List;

import com.ibm.watson.developer_cloud.concept_insights.v2.ConceptInsights;
import com.ibm.watson.developer_cloud.service.model.GenericModel;

/**
 * Concepts returned by the {@link ConceptInsights} service.
 * 
 */

public class Concepts extends GenericModel {

	/** The concepts. */
	private List<ScoredConcept> concepts;

	/**
	 * Gets the concepts.
	 * 
	 * @return The concepts
	 */
	public List<ScoredConcept> getConcepts() {
		return concepts;
	}

	/**
	 * Sets the concepts.
	 * 
	 * @param concepts
	 *            The concepts
	 */
	public void setConcepts(List<ScoredConcept> concepts) {
		this.concepts = concepts;
	}
}
