/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.tradeoff_analytics.v1;

import com.ibm.watson.developer_cloud.service.Request;
import com.ibm.watson.developer_cloud.service.WatsonService;
import com.ibm.watson.developer_cloud.tradeoff_analytics.v1.model.Dilemma;
import com.ibm.watson.developer_cloud.tradeoff_analytics.v1.model.Problem;
import com.ibm.watson.developer_cloud.util.GsonSingleton;
import com.ibm.watson.developer_cloud.util.ResponseUtil;
import java.io.IOException;
import org.apache.http.HttpResponse;

public class TradeoffAnalytics
extends WatsonService {
    private static final String GENERATE_VISUALIZATION = "GENERATE_VISUALIZATION";
    private static final String URL = "https://gateway.watsonplatform.net/tradeoff-analytics/api";

    public TradeoffAnalytics() {
        this.setEndPoint(URL);
    }

    public Dilemma dilemmas(Problem problem) {
        return this.dilemmas(problem, null);
    }

    public Dilemma dilemmas(Problem problem, Boolean generateVisualization) {
        if (problem == null) {
            throw new IllegalArgumentException("problem was not specified");
        }
        String contentJson = GsonSingleton.getGson().toJson(problem);
        Request request = Request.Post("/v1/dilemmas", new Object[0]).withContent(contentJson, "application/json");
        if (generateVisualization != null) {
            request.withQuery(GENERATE_VISUALIZATION, generateVisualization);
        }
        try {
            HttpResponse response = this.execute(request.build());
            String dilemmaJson = ResponseUtil.getString(response);
            Dilemma dilemma = GsonSingleton.getGson().fromJson(dilemmaJson, Dilemma.class);
            return dilemma;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

