/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.question_and_answer.v1;

import com.ibm.watson.developer_cloud.question_and_answer.v1.model.Pipeline;
import com.ibm.watson.developer_cloud.question_and_answer.v1.model.Question;
import com.ibm.watson.developer_cloud.question_and_answer.v1.model.QuestionAndAnswerDataset;
import com.ibm.watson.developer_cloud.question_and_answer.v1.model.WatsonAnswer;
import com.ibm.watson.developer_cloud.question_and_answer.v1.model.WatsonQuestion;
import com.ibm.watson.developer_cloud.service.Request;
import com.ibm.watson.developer_cloud.service.WatsonService;
import com.ibm.watson.developer_cloud.util.GsonSingleton;
import com.ibm.watson.developer_cloud.util.ResponseUtil;
import java.io.IOException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;

public class QuestionAndAnswer
extends WatsonService {
    private static final String URL = "https://gateway.watsonplatform.net/question-and-answer-beta/api";
    private QuestionAndAnswerDataset dataset;

    public QuestionAndAnswer() {
        this.setEndPoint(URL);
    }

    public WatsonAnswer ask(String question) {
        if (question == null || question.trim().isEmpty()) {
            throw new IllegalArgumentException("question can not be null or empty");
        }
        Question q = new Question().withQuestionText(question);
        return this.ask(q);
    }

    public WatsonAnswer ask(Question question) {
        if (this.dataset == null) {
            throw new IllegalArgumentException("dataset can not be null");
        }
        if (question == null) {
            throw new IllegalArgumentException("question can not be null");
        }
        HttpRequestBase request = Request.Post("/v1/question/%s", this.dataset.getId()).withHeader("X-synctimeout", "30").withContent(GsonSingleton.getGson().toJson(new WatsonQuestion(question)), "application/json").build();
        try {
            HttpResponse response = this.execute(request);
            String answersString = ResponseUtil.getString(response);
            Pipeline[] pipelines = GsonSingleton.getGson().fromJson(answersString, Pipeline[].class);
            return pipelines[0].getWatsonAnswer();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setDataset(QuestionAndAnswerDataset dataset) {
        this.dataset = dataset;
    }

    @Override
    public String toString() {
        return "QuestionAndAnswer [dataset=" + this.dataset + ", getEndPoint()=" + this.getEndPoint() + "]";
    }
}

