/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.natural_language_classifier.v1.util;

import com.ibm.watson.developer_cloud.natural_language_classifier.v1.model.TrainingData;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;

public class TrainingDataUtils {
    private static final Logger log = Logger.getLogger(TrainingDataUtils.class.getName());

    public static String toCSV(TrainingData ... data) {
        if (data == null || data.length == 0) {
            throw new IllegalArgumentException("data can't be null or empty");
        }
        StringWriter stringWriter = new StringWriter();
        try {
            CSVPrinter printer = new CSVPrinter(stringWriter, CSVFormat.EXCEL);
            for (TrainingData trainingData : data) {
                if (trainingData.getText() == null || trainingData.getClasses() == null || trainingData.getClasses().isEmpty()) {
                    log.log(Level.WARNING, trainingData + " couldn't be converted to a csv record");
                    continue;
                }
                ArrayList<String> record = new ArrayList<String>();
                record.add(trainingData.getText());
                record.addAll(trainingData.getClasses());
                printer.printRecord(record.toArray());
            }
            printer.close();
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Error creating the csv", e);
        }
        return stringWriter.toString();
    }

    public static List<TrainingData> fromCSV(File file, CSVFormat format) {
        if (file == null || !file.exists()) {
            throw new IllegalArgumentException("file must exists and be different than null");
        }
        ArrayList<TrainingData> trainingData = new ArrayList<TrainingData>();
        try {
            CSVParser parser = CSVParser.parse(file, Charset.forName("UTF-8"), format);
            for (CSVRecord record : parser) {
                if (record.size() > 1) {
                    trainingData.add(TrainingDataUtils.getTrainigDataFromCSVRecord(record));
                    continue;
                }
                log.warning(record.toString() + "skiped.");
            }
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Error parsing the CSV", e);
        }
        return trainingData;
    }

    private static TrainingData getTrainigDataFromCSVRecord(CSVRecord record) {
        TrainingData trainingData = new TrainingData();
        trainingData.setText(record.get(0));
        for (int i = 1; i < record.size(); ++i) {
            trainingData.addClass(record.get(i));
        }
        return trainingData;
    }
}

