/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.document_conversion.v1.helpers;

import com.google.gson.annotations.Expose;
import com.ibm.watson.developer_cloud.document_conversion.v1.DocumentConversion;
import com.ibm.watson.developer_cloud.document_conversion.v1.helpers.ConversionUtils;
import com.ibm.watson.developer_cloud.document_conversion.v1.model.OutputCollection;
import com.ibm.watson.developer_cloud.service.Request;
import com.ibm.watson.developer_cloud.util.GsonSingleton;
import com.ibm.watson.developer_cloud.util.ResponseUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Map;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;

public class OutputHelper {
    @Expose
    private DocumentConversion docConversionService;

    public OutputHelper(DocumentConversion docConversionService) {
        this.docConversionService = docConversionService;
    }

    public OutputCollection getOutputCollection(Map<String, Object> outputListParams) {
        Request request = Request.Get("/v1/output", new Object[0]);
        if (outputListParams != null) {
            String mediaType;
            String jobId;
            String token;
            if (outputListParams.get("token") != null && !(token = (String)outputListParams.get("token")).isEmpty()) {
                request.withQuery("token", token);
            }
            if (outputListParams.get("limit") != null) {
                int limit = (Integer)outputListParams.get("limit");
                if (limit > 0) {
                    request.withQuery("limit", limit);
                } else {
                    request.withQuery("limit", 100);
                }
            }
            if (outputListParams.get("since") != null) {
                Date since = (Date)outputListParams.get("since");
                request.withQuery("since", ConversionUtils.convertToISO(since));
            }
            if (outputListParams.get("job_id") != null && !(jobId = (String)outputListParams.get("job_id")).isEmpty()) {
                request.withQuery("job_id", jobId);
            }
            if (outputListParams.get("media_type") != null && !(mediaType = (String)outputListParams.get("media_type")).isEmpty()) {
                request.withQuery("media_type", mediaType);
            }
        }
        HttpRequestBase requestBase = request.build();
        try {
            HttpResponse response = this.docConversionService.execute(requestBase);
            String OutputsAsJson = ResponseUtil.getString(response);
            OutputCollection outputs = GsonSingleton.getGson().fromJson(OutputsAsJson, OutputCollection.class);
            return outputs;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public InputStream getOutput(String outputId) {
        if (outputId == null || outputId.isEmpty()) {
            throw new IllegalArgumentException("output id can not be null or empty");
        }
        HttpRequestBase request = Request.Get("/v1/output/" + outputId, new Object[0]).build();
        try {
            HttpResponse response = this.docConversionService.execute(request);
            InputStream is = ResponseUtil.getInputStream(response);
            return is;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

