/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.document_conversion.v1.helpers;

import com.google.gson.annotations.Expose;
import com.ibm.watson.developer_cloud.document_conversion.v1.DocumentConversion;
import com.ibm.watson.developer_cloud.document_conversion.v1.helpers.ConversionUtils;
import com.ibm.watson.developer_cloud.document_conversion.v1.model.Document;
import com.ibm.watson.developer_cloud.document_conversion.v1.model.DocumentCollection;
import com.ibm.watson.developer_cloud.service.Request;
import com.ibm.watson.developer_cloud.util.GsonSingleton;
import com.ibm.watson.developer_cloud.util.ResponseUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Map;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.FileBody;

public class DocumentHelper {
    @Expose
    private DocumentConversion docConversionService;

    public DocumentHelper(DocumentConversion docConversionService) {
        this.docConversionService = docConversionService;
    }

    public InputStream getDocument(String documentId) {
        if (documentId == null || documentId.isEmpty()) {
            throw new IllegalArgumentException("documentId can not be null or empty");
        }
        HttpRequestBase request = Request.Get("/v1/documents/" + documentId, new Object[0]).build();
        try {
            HttpResponse response = this.docConversionService.execute(request);
            InputStream is = ResponseUtil.getInputStream(response);
            return is;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Document uploadDocument(File document) {
        String mediaType = ConversionUtils.getMediaTypeFromFile(document);
        return this.uploadDocument(document, mediaType);
    }

    public Document uploadDocument(File document, String mediaType) {
        if (mediaType == null || mediaType.isEmpty()) {
            throw new IllegalArgumentException("media type cannot be null or empty");
        }
        if (!ConversionUtils.isValidMediaType(mediaType).booleanValue()) {
            throw new IllegalArgumentException("file with the given media type is not supported");
        }
        if (document == null || !document.exists()) {
            throw new IllegalArgumentException("document cannot be null and must exist");
        }
        try {
            MultipartEntity reqEntity = new MultipartEntity();
            reqEntity.addPart("file", new FileBody(document, mediaType));
            HttpRequestBase request = Request.Post("/v1/documents", new Object[0]).withEntity(reqEntity).build();
            HttpResponse response = this.docConversionService.execute(request);
            String documentAsJson = ResponseUtil.getString(response);
            Document doc = GsonSingleton.getGson().fromJson(documentAsJson, Document.class);
            return doc;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public DocumentCollection getDocumentCollection(Map<String, Object> docListParams) {
        Request request = Request.Get("/v1/documents", new Object[0]);
        if (docListParams != null) {
            String mediaType;
            String name;
            String token;
            if (docListParams.get("token") != null && !(token = (String)docListParams.get("token")).isEmpty()) {
                request.withQuery("token", token);
            }
            if (docListParams.get("limit") != null) {
                int limit = (Integer)docListParams.get("limit");
                if (limit > 0) {
                    request.withQuery("limit", limit);
                } else {
                    request.withQuery("limit", 100);
                }
            }
            if (docListParams.get("name") != null && !(name = (String)docListParams.get("name")).isEmpty()) {
                request.withQuery("name", name);
            }
            if (docListParams.get("since") != null) {
                Date since = (Date)docListParams.get("since");
                request.withQuery("since", ConversionUtils.convertToISO(since));
            }
            if (docListParams.get("media_type") != null && !(mediaType = (String)docListParams.get("media_type")).isEmpty()) {
                request.withQuery("media_type", mediaType);
            }
        }
        HttpRequestBase requestBase = request.build();
        try {
            HttpResponse response = this.docConversionService.execute(requestBase);
            String documentCollectionAsJson = ResponseUtil.getString(response);
            DocumentCollection documentCollection = GsonSingleton.getGson().fromJson(documentCollectionAsJson, DocumentCollection.class);
            return documentCollection;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

