/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.document_conversion.v1.helpers;

import java.io.File;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Scanner;
import java.util.TimeZone;

public class ConversionUtils {
    private static final String DATE_FORMAT_UTC = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";

    public static String getMediaTypeFromFile(File file) {
        if (file != null) {
            String fileName = file.getName().toLowerCase();
            String[] supportedExtensions = new String[]{".htm", ".html", ".dot", ".doc", ".docx", ".xml", ".xhtml", ".pdf"};
            String[] supportedMediaTypes = new String[]{"text/html", "text/html", "application/msword", "application/msword", "application/vnd.openxmlformats-officedocument.wordprocessingml.document", "application/xhtml+xml", "application/xhtml+xml", "application/pdf"};
            for (int i = 0; i < supportedMediaTypes.length; ++i) {
                if (!fileName.endsWith(supportedExtensions[i])) continue;
                return supportedMediaTypes[i];
            }
        }
        return null;
    }

    public static Boolean isValidMediaType(String mediaType) {
        if (mediaType != null) {
            String[] supportedMediaTypes = new String[]{"text/html", "application/msword", "application/vnd.openxmlformats-officedocument.wordprocessingml.document", "application/xhtml+xml", "application/pdf"};
            for (int i = 0; i < supportedMediaTypes.length; ++i) {
                if (!mediaType.equalsIgnoreCase(supportedMediaTypes[i])) continue;
                return true;
            }
        }
        return false;
    }

    public static String convertToISO(Date date) {
        TimeZone tz = TimeZone.getTimeZone("UTC");
        SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT_UTC);
        df.setTimeZone(tz);
        String dtAsISO = df.format(date);
        return dtAsISO;
    }

    public static String writeInputStreamToString(InputStream is) {
        Scanner s = new Scanner(is).useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }
}

