/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.dialog.v1;

import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.ibm.watson.developer_cloud.dialog.v1.model.Conversation;
import com.ibm.watson.developer_cloud.dialog.v1.model.ConversationData;
import com.ibm.watson.developer_cloud.dialog.v1.model.Dialog;
import com.ibm.watson.developer_cloud.dialog.v1.model.DialogContent;
import com.ibm.watson.developer_cloud.dialog.v1.model.NameValue;
import com.ibm.watson.developer_cloud.service.Request;
import com.ibm.watson.developer_cloud.service.WatsonService;
import com.ibm.watson.developer_cloud.util.GsonSingleton;
import com.ibm.watson.developer_cloud.util.ResponseUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;

public class DialogService
extends WatsonService {
    public static final String CLIENT_ID = "client_id";
    public static final String CONVERSATION_ID = "conversation_id";
    public static final String DIALOG_ID = "dialog_id";
    public static final String INPUT = "input";
    public static final String DATE_FROM = "date_from";
    public static final String DATE_TO = "date_to";
    public static final String LIMIT = "limit";
    public static final String OFFSET = "offset";
    public static final String NAME_VALUES = "name_values";
    private static final Type listDialogContentType = new TypeToken<List<DialogContent>>(){}.getType();
    private static final Type listDialogType = new TypeToken<List<Dialog>>(){}.getType();
    private static Type listNameValueType = new TypeToken<List<NameValue>>(){}.getType();
    private static final Type listConversationDataType = new TypeToken<List<ConversationData>>(){}.getType();
    private static final Logger log = Logger.getLogger(DialogService.class.getName());
    private static final SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final String URL = "https://gateway.watsonplatform.net/dialog-beta/api";

    public DialogService() {
        this.setEndPoint(URL);
    }

    public Conversation converse(Map<String, Object> params) {
        String dialogId = (String)params.get(DIALOG_ID);
        String input = (String)params.get(INPUT);
        Integer clientId = (Integer)params.get(CLIENT_ID);
        Integer conversationId = (Integer)params.get(CONVERSATION_ID);
        if (dialogId == null || dialogId.isEmpty()) {
            throw new IllegalArgumentException("dialog_id can not be null or empty");
        }
        if (conversationId == null) {
            log.info("Creating a new conversation with for dialog: " + dialogId);
        }
        if (clientId == null) {
            log.info("Creating a new client id with for dialog: " + dialogId);
        }
        String path = String.format("/v1/dialogs/%s/conversation", dialogId);
        HttpRequestBase request = Request.Post(path, new Object[0]).withForm(CONVERSATION_ID, conversationId, CLIENT_ID, clientId, INPUT, input).build();
        try {
            HttpResponse response = this.execute(request);
            Conversation conversation = ResponseUtil.getObject(response, Conversation.class);
            return conversation;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Conversation createConversation(String dialogId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(DIALOG_ID, dialogId);
        return this.converse(params);
    }

    public Dialog createDialog(String name, File dialogFile) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("name can not be null or empty");
        }
        if (dialogFile == null || !dialogFile.exists()) {
            throw new IllegalArgumentException("dialogFile can not be null or empty");
        }
        try {
            MultipartEntity reqEntity = new MultipartEntity();
            reqEntity.addPart("file", new FileBody(dialogFile));
            reqEntity.addPart("name", new StringBody(name, Charset.forName("UTF-8")));
            HttpRequestBase request = Request.Post("/v1/dialogs", new Object[0]).withEntity(reqEntity).build();
            HttpResponse response = this.execute(request);
            return ResponseUtil.getObject(response, Dialog.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteDialog(String dialogId) {
        if (dialogId == null || dialogId.isEmpty()) {
            throw new IllegalArgumentException("dialogId can not be null or empty");
        }
        HttpRequestBase request = Request.Delete("/v1/dialogs/" + dialogId, new Object[0]).build();
        this.executeWithoutResponse(request);
    }

    public List<DialogContent> getContent(String dialogId) {
        if (dialogId == null || dialogId.isEmpty()) {
            throw new IllegalArgumentException("dialogId can not be null or empty");
        }
        HttpRequestBase request = Request.Get("/v1/dialogs/" + dialogId + "/content", new Object[0]).build();
        try {
            HttpResponse response = this.execute(request);
            JsonObject jsonObject = ResponseUtil.getJsonObject(response);
            List content = (List)GsonSingleton.getGson().fromJson(jsonObject.get("items"), listDialogContentType);
            return content;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<Dialog> getDialogs() {
        HttpRequestBase request = Request.Get("/v1/dialogs", new Object[0]).build();
        try {
            HttpResponse response = this.execute(request);
            JsonObject jsonObject = ResponseUtil.getJsonObject(response);
            List dialogs = (List)GsonSingleton.getGson().fromJson(jsonObject.get("dialogs"), listDialogType);
            return dialogs;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<NameValue> getProfile(String dialogId, Integer clientId) {
        if (dialogId == null || dialogId.isEmpty()) {
            throw new IllegalArgumentException("dialogId can not be null or empty");
        }
        if (clientId == null) {
            throw new IllegalArgumentException("clientId can not be null");
        }
        HttpRequestBase request = Request.Get("/v1/dialogs/" + dialogId + "/profile", new Object[0]).withQuery(CLIENT_ID, clientId).build();
        try {
            HttpResponse response = this.execute(request);
            JsonObject jsonObject = ResponseUtil.getJsonObject(response);
            List content = (List)GsonSingleton.getGson().fromJson(jsonObject.get(NAME_VALUES), listNameValueType);
            return content;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<ConversationData> getConversationData(Map<String, Object> params) {
        String dialogId = (String)params.get(DIALOG_ID);
        Date from = (Date)params.get(DATE_FROM);
        Date to = (Date)params.get(DATE_TO);
        Integer offset = (Integer)params.get(OFFSET);
        Integer limit = (Integer)params.get(LIMIT);
        if (dialogId == null || dialogId.isEmpty()) {
            throw new IllegalArgumentException("dialog_id can not be null or empty");
        }
        if (from == null) {
            throw new IllegalArgumentException("date_from can not be null");
        }
        if (to == null) {
            throw new IllegalArgumentException("date_to can not be null");
        }
        if (from.after(to)) {
            throw new IllegalArgumentException("'date_from' is greater than 'date_to'");
        }
        String fromString = sdfDate.format(from);
        String toString = sdfDate.format(to);
        String path = String.format("/v1/dialogs/%s/conversation", dialogId);
        Request requestBuilder = Request.Get(path, new Object[0]).withQuery(DATE_FROM, fromString, DATE_TO, toString);
        if (offset != null) {
            requestBuilder.withQuery(OFFSET, offset);
        }
        if (limit != null) {
            requestBuilder.withQuery(LIMIT, limit);
        }
        HttpRequestBase request = requestBuilder.build();
        try {
            HttpResponse response = this.execute(request);
            JsonObject jsonObject = ResponseUtil.getJsonObject(response);
            List conversationDataList = (List)GsonSingleton.getGson().fromJson(jsonObject.get("conversations"), listConversationDataType);
            return conversationDataList;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DialogService [getEndPoint()=");
        builder.append(this.getEndPoint());
        builder.append("]");
        return builder.toString();
    }

    public Dialog updateDialog(String dialogId, File dialogFile) {
        if (dialogId == null || dialogId.isEmpty()) {
            throw new IllegalArgumentException("dialogId can not be null or empty");
        }
        if (dialogFile == null || !dialogFile.exists()) {
            throw new IllegalArgumentException("dialogFile can not be null or empty");
        }
        MultipartEntity reqEntity = new MultipartEntity();
        reqEntity.addPart("file", new FileBody(dialogFile));
        HttpRequestBase request = Request.Put("/v1/dialogs/" + dialogId, new Object[0]).withEntity(reqEntity).build();
        this.executeWithoutResponse(request);
        Dialog dialog = new Dialog().withDialogId(dialogId);
        return dialog;
    }

    public void updateProfile(String dialogId, Integer clientId, List<NameValue> nameValues) {
        if (dialogId == null || dialogId.isEmpty()) {
            throw new IllegalArgumentException("dialogId can not be null or empty");
        }
        if (clientId == null) {
            throw new IllegalArgumentException("clientId can not be null");
        }
        if (nameValues == null || nameValues.isEmpty()) {
            throw new IllegalArgumentException("nameValues can not be null or empty");
        }
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty(CLIENT_ID, clientId);
        contentJson.add(NAME_VALUES, GsonSingleton.getGson().toJsonTree(nameValues));
        HttpRequestBase request = Request.Put("/v1/dialogs/" + dialogId + "/profile", new Object[0]).withContent(contentJson).build();
        this.executeWithoutResponse(request);
    }
}

