/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.concept_insights.v2;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.ibm.watson.developer_cloud.concept_insights.v2.model.Accounts;
import com.ibm.watson.developer_cloud.concept_insights.v2.model.Annotations;
import com.ibm.watson.developer_cloud.concept_insights.v2.model.ConceptMetadata;
import com.ibm.watson.developer_cloud.concept_insights.v2.model.Concepts;
import com.ibm.watson.developer_cloud.concept_insights.v2.model.Corpora;
import com.ibm.watson.developer_cloud.concept_insights.v2.model.Corpus;
import com.ibm.watson.developer_cloud.concept_insights.v2.model.CorpusProcessingState;
import com.ibm.watson.developer_cloud.concept_insights.v2.model.CorpusStats;
import com.ibm.watson.developer_cloud.concept_insights.v2.model.Document;
import com.ibm.watson.developer_cloud.concept_insights.v2.model.DocumentAnnotations;
import com.ibm.watson.developer_cloud.concept_insights.v2.model.DocumentProcessingStatus;
import com.ibm.watson.developer_cloud.concept_insights.v2.model.Documents;
import com.ibm.watson.developer_cloud.concept_insights.v2.model.Graphs;
import com.ibm.watson.developer_cloud.concept_insights.v2.model.Matches;
import com.ibm.watson.developer_cloud.concept_insights.v2.model.QueryConcepts;
import com.ibm.watson.developer_cloud.concept_insights.v2.model.RequestedFields;
import com.ibm.watson.developer_cloud.concept_insights.v2.model.Scores;
import com.ibm.watson.developer_cloud.service.Request;
import com.ibm.watson.developer_cloud.service.WatsonService;
import com.ibm.watson.developer_cloud.util.GsonSingleton;
import com.ibm.watson.developer_cloud.util.ResponseUtil;
import com.ibm.watson.developer_cloud.util.Validate;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingFormatArgumentException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;

public class ConceptInsights
extends WatsonService {
    public static final String ACCOUNT_ID = "account_id";
    public static final String CONCEPT_ID = "concept_id";
    private static final String ACCOUNTS_PATH = "/v2/accounts";
    private static final String ANNOTATE_TEXT_PATH = "annotate_text";
    private static final String ANNOTATIONS_PATH = "annotations";
    public static final String CONCEPT = "concept";
    public static final String CONCEPT_FIELDS = "concept_fields";
    public static final String CONCEPTS = "concepts";
    private static final String CONCEPTUAL_SEARCH_PATH = "conceptual_search";
    private static final String CORPORA_PATH = "/v2/corpora";
    public static final String CORPUS = "corpus";
    public static final String CURSOR = "cursor";
    public static final String DOCUMENT = "document";
    public static final String DOCUMENT_FIELDS = "document_fields";
    public static final String DOCUMENTS = "documents";
    public static final String GRAPH = "graph";
    private static final String GRAPHS_PATH = "/v2/graphs";
    public static final String IDS = "ids";
    private static final String LABEL_SEARCH_PATH = "label_search";
    public static final String LEVEL = "level";
    public static final String LIMIT = "limit";
    public static final String PREFIX = "prefix";
    private static final String PROCESSING_STATE_PATH = "processing_state";
    public static final String QUERY = "query";
    private static final String RELATED_CONCEPTS_PATH = "related_concepts";
    private static final String RELATION_SCORES_PATH = "relation_scores";
    private static final String STATS_PATH = "stats";
    public static final String TEXT = "text";
    private static final String URL = "https://gateway.watsonplatform.net/concept-insights/api";

    private static String createConceptIdPath(String accountId, String graph, String concept) {
        return String.format("%s/%s/%s/%s/%s/", GRAPHS_PATH, accountId, graph, CONCEPTS, concept);
    }

    private static String createCorpusIdPath(String accountId, String corpus) {
        return String.format("%s/%s/%s/", CORPORA_PATH, accountId, corpus);
    }

    private static String createDocumentIdPath(String accountId, String corpus, String document) {
        return String.format("%s/%s/%s/%s/%s/", CORPORA_PATH, accountId, corpus, DOCUMENTS, document);
    }

    private static String createGraphIdPath(String accountId, String graph) {
        return String.format("%s/%s/%s/", GRAPHS_PATH, accountId, graph);
    }

    public ConceptInsights() {
        this.setEndPoint(URL);
    }

    public Annotations annotateText(Map<String, Object> parameters) {
        Validate.notNull(parameters.get(ACCOUNT_ID), "account_id can't be null");
        Validate.notNull(parameters.get(GRAPH), "graph can't be null");
        Validate.notNull(parameters.get(TEXT), "text can't be null");
        String graphId = ConceptInsights.createGraphIdPath((String)parameters.get(ACCOUNT_ID), (String)parameters.get(GRAPH));
        HttpRequestBase request = Request.Post(graphId + ANNOTATE_TEXT_PATH, new Object[0]).withContent((String)parameters.get(TEXT), "text/plain").withHeader("Accept", "application/json").build();
        try {
            HttpResponse response = this.execute(request);
            Annotations annotations = GsonSingleton.getGson().fromJson(ResponseUtil.getString(response), Annotations.class);
            return annotations;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public QueryConcepts conceptualSearch(Map<String, Object> parameters) {
        RequestedFields fields;
        String[] queryParameters;
        Validate.notNull(parameters.get(ACCOUNT_ID), "account_id can't be null");
        Validate.notNull(parameters.get(CORPUS), "corpus can't be null");
        Validate.notNull(parameters.get(IDS), "ids can't be null");
        String corpusId = ConceptInsights.createCorpusIdPath((String)parameters.get(ACCOUNT_ID), (String)parameters.get(CORPUS));
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        for (String param : queryParameters = new String[]{CURSOR, LIMIT}) {
            if (!parameters.containsKey(param)) continue;
            queryParams.put(param, parameters.get(param));
        }
        JsonArray IdsJsonArray = new JsonArray();
        List ids = (List)parameters.get(IDS);
        for (String value : ids) {
            IdsJsonArray.add(new JsonPrimitive(value));
        }
        queryParams.put(IDS, IdsJsonArray.toString());
        if (parameters.get(CONCEPT_FIELDS) != null && (fields = (RequestedFields)parameters.get(CONCEPT_FIELDS)) != null && fields.getFields() != null && !fields.getFields().isEmpty()) {
            queryParams.put(CONCEPT_FIELDS, fields.toString());
        }
        if (parameters.get(DOCUMENT_FIELDS) != null && (fields = (RequestedFields)parameters.get(DOCUMENT_FIELDS)) != null && fields.getFields() != null && !fields.getFields().isEmpty()) {
            queryParams.put(DOCUMENT_FIELDS, fields.toString());
        }
        return this.executeRequest(corpusId + CONCEPTUAL_SEARCH_PATH, queryParams, QueryConcepts.class);
    }

    public void createCorpus(String accountId, Corpus corpus) {
        Validate.notNull(accountId, "account_id can't be null");
        Validate.notNull(corpus, "corpus can't be null");
        Validate.notNull(corpus.getId(), "corpus.id can't be null");
        HttpRequestBase request = Request.Put(ConceptInsights.createCorpusIdPath(accountId, corpus.getId()), new Object[0]).withContent(GsonSingleton.getGson().toJson(corpus), "application/json").build();
        this.executeWithoutResponse(request);
    }

    public void createDocument(String accountId, String corpusName, Document document) {
        Validate.notNull(accountId, "accountId can't be null");
        Validate.notNull(corpusName, "corpusName can't be null");
        Validate.notNull(document, "document can't be null");
        Validate.notNull(document.getId(), "document.id can't be null");
        HttpRequestBase request = Request.Put(ConceptInsights.createDocumentIdPath(accountId, corpusName, document.getId()), new Object[0]).withContent(GsonSingleton.getGson().toJson(document), "application/json").build();
        this.executeWithoutResponse(request);
    }

    public void deleteCorpus(String accountId, String corpusName) {
        Validate.notNull(accountId, "accountId can't be null");
        Validate.notNull(corpusName, "corpusName can't be null");
        HttpRequestBase request = Request.Delete(ConceptInsights.createCorpusIdPath(accountId, corpusName), new Object[0]).build();
        this.executeWithoutResponse(request);
    }

    public void deleteDocument(String accountId, String corpusName, String documentName) {
        Validate.notNull(accountId, "accountId can't be null");
        Validate.notNull(corpusName, "corpusName can't be null");
        Validate.notNull(documentName, "documentName can't be null");
        HttpRequestBase request = Request.Delete(ConceptInsights.createDocumentIdPath(accountId, corpusName, documentName), new Object[0]).build();
        this.executeWithoutResponse(request);
    }

    public Accounts getAccountsInfo() {
        return this.executeRequest(ACCOUNTS_PATH, null, Accounts.class);
    }

    public ConceptMetadata getConcept(Map<String, Object> parameters) {
        Validate.notNull(parameters.get(ACCOUNT_ID), "account_id can't be null");
        Validate.notNull(parameters.get(GRAPH), "graph can't be null");
        Validate.notNull(parameters.get(CONCEPT), "concept can't be null");
        String conceptId = ConceptInsights.createConceptIdPath((String)parameters.get(ACCOUNT_ID), (String)parameters.get(GRAPH), (String)parameters.get(CONCEPT));
        return this.executeRequest(conceptId, null, ConceptMetadata.class);
    }

    public Corpus getCorpus(String accountId, String corpusName) {
        Validate.notNull(accountId, "accountId can't be null");
        Validate.notNull(corpusName, "corpusName can't be null");
        return this.executeRequest(ConceptInsights.createCorpusIdPath(accountId, corpusName), null, Corpus.class);
    }

    public CorpusProcessingState getCorpusProcessingState(String accountId, String corpusName) {
        Validate.notNull(accountId, "accountId can't be null");
        Validate.notNull(corpusName, "corpusName can't be null");
        return this.executeRequest(ConceptInsights.createCorpusIdPath(accountId, corpusName) + PROCESSING_STATE_PATH, null, CorpusProcessingState.class);
    }

    public Concepts getCorpusRelatedConcepts(Map<String, Object> parameters) {
        RequestedFields fields;
        String[] params;
        Validate.notNull(parameters.get(ACCOUNT_ID), "account_id can't be null");
        Validate.notNull(parameters.get(CORPUS), "corpus can't be null");
        String corpusId = ConceptInsights.createCorpusIdPath((String)parameters.get(ACCOUNT_ID), (String)parameters.get(CORPUS));
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        for (String param : params = new String[]{LEVEL, LIMIT}) {
            if (!parameters.containsKey(param)) continue;
            queryParameters.put(param, parameters.get(param));
        }
        if (parameters.get(CONCEPT_FIELDS) != null && (fields = (RequestedFields)parameters.get(CONCEPT_FIELDS)) != null && fields.getFields() != null && !fields.getFields().isEmpty()) {
            queryParameters.put(CONCEPT_FIELDS, fields.toString());
        }
        return this.executeRequest(corpusId + RELATED_CONCEPTS_PATH, queryParameters, Concepts.class);
    }

    public Scores getCorpusRelationScores(Map<String, Object> parameters) {
        Validate.notNull(parameters.get(ACCOUNT_ID), "account_id can't be null");
        Validate.notNull(parameters.get(CORPUS), "corpus can't be null");
        Validate.notNull(parameters.get(CONCEPTS), "concepts can't be null");
        String corpusId = ConceptInsights.createCorpusIdPath((String)parameters.get(ACCOUNT_ID), (String)parameters.get(CORPUS));
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        JsonObject contentJson = new JsonObject();
        JsonArray conceptsJson = new JsonArray();
        List concepts = (List)parameters.get(CONCEPTS);
        for (String value : concepts) {
            conceptsJson.add(new JsonPrimitive(value));
        }
        contentJson.add(CONCEPTS, conceptsJson);
        queryParameters.put(CONCEPTS, conceptsJson.toString());
        return this.executeRequest(corpusId + RELATION_SCORES_PATH, queryParameters, Scores.class);
    }

    public CorpusStats getCorpusStats(String accountId, String corpusName) {
        Validate.notNull(accountId, "accountId can't be null");
        Validate.notNull(corpusName, "corpusName can't be null");
        return this.executeRequest(ConceptInsights.createCorpusIdPath(accountId, corpusName) + STATS_PATH, null, CorpusStats.class);
    }

    public Document getDocument(String accountId, String corpusName, String documentName) {
        Validate.notNull(accountId, "accountId can't be null");
        Validate.notNull(corpusName, "corpusName can't be null");
        Validate.notNull(documentName, "documentName can't be null");
        return this.executeRequest(ConceptInsights.createDocumentIdPath(accountId, corpusName, documentName), null, Document.class);
    }

    public DocumentAnnotations getDocumentAnnotations(String accountId, String corpusName, String documentName) {
        Validate.notNull(accountId, "accountId can't be null");
        Validate.notNull(corpusName, "corpusName can't be null");
        Validate.notNull(documentName, "documentName can't be null");
        String documentId = ConceptInsights.createDocumentIdPath(accountId, corpusName, documentName);
        return this.executeRequest(documentId + ANNOTATIONS_PATH, null, DocumentAnnotations.class);
    }

    public DocumentProcessingStatus getDocumentProcessingState(String accountId, String corpusName, String documentName) {
        Validate.notNull(accountId, "accountId can't be null");
        Validate.notNull(corpusName, "corpusName can't be null");
        Validate.notNull(documentName, "documentName can't be null");
        String documentId = ConceptInsights.createDocumentIdPath(accountId, corpusName, documentName);
        return this.executeRequest(documentId + PROCESSING_STATE_PATH, null, DocumentProcessingStatus.class);
    }

    public Concepts getDocumentRelatedConcepts(Map<String, Object> parameters) {
        RequestedFields fields;
        Validate.notNull(parameters.get(ACCOUNT_ID), "account_id can't be null");
        Validate.notNull(parameters.get(CORPUS), "corpus can't be null");
        Validate.notNull(parameters.get(DOCUMENT), "document can't be null");
        String documentId = ConceptInsights.createDocumentIdPath((String)parameters.get(ACCOUNT_ID), (String)parameters.get(CORPUS), (String)parameters.get(DOCUMENT));
        String[] queryParameters = new String[]{LEVEL, LIMIT};
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        for (String param : queryParameters) {
            if (!parameters.containsKey(param)) continue;
            queryParams.put(param, parameters.get(param));
        }
        if (parameters.get(CONCEPT_FIELDS) != null && (fields = (RequestedFields)parameters.get(CONCEPT_FIELDS)) != null && fields.getFields() != null && !fields.getFields().isEmpty()) {
            queryParams.put(CONCEPT_FIELDS, fields.toString());
        }
        return this.executeRequest(documentId + RELATED_CONCEPTS_PATH, queryParams, Concepts.class);
    }

    public Scores getDocumentRelationScores(Map<String, Object> parameters) {
        Validate.notNull(parameters.get(ACCOUNT_ID), "account_id can't be null");
        Validate.notNull(parameters.get(CORPUS), "corpus can't be null");
        Validate.notNull(parameters.get(DOCUMENT), "document can't be null");
        Validate.notNull(parameters.get(CONCEPTS), "concepts can't be null");
        String documentId = ConceptInsights.createDocumentIdPath((String)parameters.get(ACCOUNT_ID), (String)parameters.get(CORPUS), (String)parameters.get(DOCUMENT));
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        JsonObject contentJson = new JsonObject();
        JsonArray conceptsJson = new JsonArray();
        List list = (List)parameters.get(CONCEPTS);
        for (String value : list) {
            conceptsJson.add(new JsonPrimitive(value));
        }
        contentJson.add(CONCEPTS, conceptsJson);
        queryParams.put(CONCEPTS, conceptsJson.toString());
        return this.executeRequest(documentId + RELATION_SCORES_PATH, queryParams, Scores.class);
    }

    public Concepts getGraphsRelatedConcepts(Map<String, Object> parameters) {
        RequestedFields fields;
        String[] queryParms;
        Validate.notNull(parameters.get(ACCOUNT_ID), "account_id can't be null");
        Validate.notNull(parameters.get(GRAPH), "graph can't be null");
        if (parameters.get(CONCEPTS) == null && parameters.get(CONCEPT) == null) {
            throw new MissingFormatArgumentException("concept or concepts should be identified");
        }
        String graphId = ConceptInsights.createGraphIdPath((String)parameters.get(ACCOUNT_ID), (String)parameters.get(GRAPH));
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        for (String param : queryParms = new String[]{LEVEL, LIMIT}) {
            if (!parameters.containsKey(param)) continue;
            queryParameters.put(param, parameters.get(param));
        }
        if (parameters.get(CONCEPT_FIELDS) != null && (fields = (RequestedFields)parameters.get(CONCEPT_FIELDS)) != null && fields.getFields() != null && !fields.getFields().isEmpty()) {
            queryParameters.put(CONCEPT_FIELDS, fields.toString());
        }
        if (parameters.get(CONCEPTS) != null) {
            JsonObject contentJson = new JsonObject();
            JsonArray conceptsJson = new JsonArray();
            List concepts = (List)parameters.get(CONCEPTS);
            for (String value : concepts) {
                conceptsJson.add(new JsonPrimitive(value));
            }
            contentJson.add(CONCEPTS, conceptsJson);
            queryParameters.put(CONCEPTS, conceptsJson.toString());
            return this.executeRequest(graphId + RELATED_CONCEPTS_PATH, queryParameters, Concepts.class);
        }
        String conceptId = ConceptInsights.createConceptIdPath((String)parameters.get(ACCOUNT_ID), (String)parameters.get(GRAPH), (String)parameters.get(CONCEPT));
        return this.executeRequest(conceptId + RELATED_CONCEPTS_PATH, queryParameters, Concepts.class);
    }

    public Scores getGraphsRelationScores(Map<String, Object> parameters) {
        Validate.notNull(parameters.get(ACCOUNT_ID), "account_id can't be null");
        Validate.notNull(parameters.get(GRAPH), "graph can't be null");
        Validate.notNull(parameters.get(CONCEPT), "concept can't be null");
        Validate.notNull(parameters.get(CONCEPTS), "concepts can't be null");
        String conceptId = ConceptInsights.createConceptIdPath((String)parameters.get(ACCOUNT_ID), (String)parameters.get(GRAPH), (String)parameters.get(CONCEPT));
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        JsonObject contentJson = new JsonObject();
        JsonArray conceptsJson = new JsonArray();
        List concepts = (List)parameters.get(CONCEPTS);
        for (String value : concepts) {
            conceptsJson.add(new JsonPrimitive(value));
        }
        contentJson.add(CONCEPTS, conceptsJson);
        queryParameters.put(CONCEPTS, conceptsJson.toString());
        return this.executeRequest(conceptId + RELATION_SCORES_PATH, queryParameters, Scores.class);
    }

    public Corpora listCorpora() {
        return this.executeRequest(CORPORA_PATH, null, Corpora.class);
    }

    public Corpora listCorpora(String accountId) {
        Validate.notNull(accountId, "account_id can't be null");
        return this.executeRequest("/v2/corpora/" + accountId, null, Corpora.class);
    }

    public Documents listDocuments(Map<String, Object> parameters) {
        String[] queryParams;
        Validate.notNull(parameters.get(ACCOUNT_ID), "account_id can't be null");
        Validate.notNull(parameters.get(CORPUS), "corpus can't be null");
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        for (String param : queryParams = new String[]{CURSOR, LIMIT}) {
            if (!parameters.containsKey(param)) continue;
            queryParameters.put(param, parameters.get(param));
        }
        if (parameters.get(QUERY) != null) {
            queryParameters.put(QUERY, parameters.get(QUERY));
        }
        return this.executeRequest(ConceptInsights.createCorpusIdPath((String)parameters.get(ACCOUNT_ID), (String)parameters.get(CORPUS)) + DOCUMENTS, queryParameters, Documents.class);
    }

    public Graphs listGraphs() {
        return this.executeRequest(GRAPHS_PATH, null, Graphs.class);
    }

    public Matches searchCorpusByLabel(Map<String, Object> parameters) {
        RequestedFields fields;
        String[] queryParams;
        Validate.notNull(parameters.get(ACCOUNT_ID), "account_id can't be null");
        Validate.notNull(parameters.get(CORPUS), "corpus can't be null");
        Validate.notNull(parameters.get(QUERY), "query can't be null");
        String corpusId = ConceptInsights.createCorpusIdPath((String)parameters.get(ACCOUNT_ID), (String)parameters.get(CORPUS));
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        for (String param : queryParams = new String[]{QUERY, PREFIX, LIMIT, CONCEPTS}) {
            if (!parameters.containsKey(param)) continue;
            queryParameters.put(param, parameters.get(param));
        }
        if (parameters.get(CONCEPT_FIELDS) != null && (fields = (RequestedFields)parameters.get(CONCEPT_FIELDS)) != null && fields.getFields() != null && !fields.getFields().isEmpty()) {
            queryParameters.put(CONCEPT_FIELDS, fields.toString());
        }
        if (parameters.get(DOCUMENT_FIELDS) != null && (fields = (RequestedFields)parameters.get(DOCUMENT_FIELDS)) != null && fields.getFields() != null && !fields.getFields().isEmpty()) {
            queryParameters.put(DOCUMENT_FIELDS, fields.toString());
        }
        return this.executeRequest(corpusId + LABEL_SEARCH_PATH, queryParameters, Matches.class);
    }

    public Matches searchGraphsConceptByLabel(Map<String, Object> parameters) {
        RequestedFields fields;
        String[] params;
        Validate.notNull(parameters.get(ACCOUNT_ID), "account_id can't be null");
        Validate.notNull(parameters.get(GRAPH), "graph can't be null");
        Validate.notNull(parameters.get(QUERY), "query can't be null");
        String graph_id = ConceptInsights.createGraphIdPath((String)parameters.get(ACCOUNT_ID), (String)parameters.get(GRAPH));
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        for (String param : params = new String[]{QUERY, PREFIX, LIMIT}) {
            if (!parameters.containsKey(param)) continue;
            queryParameters.put(param, parameters.get(param));
        }
        if (parameters.get(CONCEPT_FIELDS) != null && (fields = (RequestedFields)parameters.get(CONCEPT_FIELDS)) != null && fields.getFields() != null && !fields.getFields().isEmpty()) {
            queryParameters.put(CONCEPT_FIELDS, fields.toString());
        }
        return this.executeRequest(graph_id + LABEL_SEARCH_PATH, queryParameters, Matches.class);
    }

    public void updateCorpus(String accountId, Corpus corpus) {
        Validate.notNull(accountId, "account_id can't be null");
        Validate.notNull(corpus, "corpus can't be null");
        Validate.notNull(corpus.getId(), "corpus.id can't be null");
        HttpRequestBase request = Request.Post(ConceptInsights.createCorpusIdPath(accountId, corpus.getId()), new Object[0]).withContent(GsonSingleton.getGson().toJson(corpus), "application/json").build();
        this.executeWithoutResponse(request);
    }

    public void updateDocument(String accountId, String corpusName, Document document) {
        Validate.notNull(accountId, "accountId can't be null");
        Validate.notNull(corpusName, "corpusName can't be null");
        Validate.notNull(document, "document can't be null");
        Validate.notNull(document.getId(), "document.id can't be null");
        HttpRequestBase request = Request.Post(ConceptInsights.createDocumentIdPath(accountId, corpusName, document.getId()), new Object[0]).withContent(GsonSingleton.getGson().toJson(document), "application/json").build();
        this.executeWithoutResponse(request);
    }

    private <T> T executeRequest(String resourcePath, Map<String, Object> params, Class<T> returnType) {
        Request request = Request.Get(resourcePath, new Object[0]);
        if (params != null && !params.isEmpty()) {
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                request.withQuery(entry.getKey(), entry.getValue());
            }
        }
        HttpRequestBase requestBase = request.build();
        try {
            HttpResponse response = this.execute(requestBase);
            return ResponseUtil.getObject(response, returnType);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

