/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.concept_expansion.v1;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.ibm.watson.developer_cloud.concept_expansion.v1.model.Concept;
import com.ibm.watson.developer_cloud.concept_expansion.v1.model.ConceptExpansionDataset;
import com.ibm.watson.developer_cloud.concept_expansion.v1.model.Job;
import com.ibm.watson.developer_cloud.service.Request;
import com.ibm.watson.developer_cloud.service.WatsonService;
import com.ibm.watson.developer_cloud.util.GsonSingleton;
import com.ibm.watson.developer_cloud.util.ResponseUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;

public class ConceptExpansion
extends WatsonService {
    public static final String SEEDS = "seeds";
    public static final String DATASET = "dataset";
    public static final String LABEL = "label";
    private static final String PARAM_STATE = "state";
    private static final String PARAM_JOBID = "jobid";
    private static String URL = "https://gateway.watsonplatform.net/concept-expansion-beta/api";
    private static final Map<String, String> decoderHash = new HashMap<String, String>();
    private ConceptExpansionDataset dataset;

    public ConceptExpansion() {
        this.setEndPoint(URL);
    }

    public Job createJob(String label, String[] seeds) {
        if (this.dataset == null) {
            throw new IllegalArgumentException("dataset can not be null or empty");
        }
        if (label == null) {
            throw new IllegalArgumentException("label can not be null or empty");
        }
        if (seeds == null || seeds.length == 0) {
            throw new IllegalArgumentException("seeds can not be null or empty");
        }
        try {
            JsonArray seedJsonArray = new JsonArray();
            for (String seed : seeds) {
                seedJsonArray.add(new JsonPrimitive(seed));
            }
            JsonObject payload = new JsonObject();
            payload.addProperty(LABEL, label);
            payload.addProperty(DATASET, this.dataset.getId());
            payload.add(SEEDS, seedJsonArray);
            HttpRequestBase request = Request.Post("/v1/upload", new Object[0]).withContent(payload).build();
            HttpResponse response = this.execute(request);
            String jsonJob = ResponseUtil.getString(response);
            return GsonSingleton.getGson().fromJson(jsonJob, Job.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String decodeResult(String result) {
        for (String key : decoderHash.keySet()) {
            result = result.replaceAll(" " + key, decoderHash.get(key));
            result = result.replaceAll(key, decoderHash.get(key));
        }
        return result;
    }

    private Concept formatConcept(JsonObject conceptJson) {
        return new Concept(conceptJson.get("result").getAsString(), conceptJson.get("prevalence").getAsDouble());
    }

    private List<Concept> formatConcepts(JsonObject conceptsJson) {
        JsonArray conceptArray = conceptsJson.get("return_seeds").getAsJsonArray();
        ArrayList<Concept> concepts = new ArrayList<Concept>();
        for (JsonElement conceptJson : conceptArray) {
            concepts.add(this.formatConcept(conceptJson.getAsJsonObject()));
        }
        return concepts;
    }

    public ConceptExpansionDataset getDataset() {
        return this.dataset;
    }

    public List<Concept> getJobResult(Job job) {
        if (job == null) {
            throw new IllegalArgumentException("job can not be null");
        }
        if (job.getId() == null) {
            throw new IllegalArgumentException("job.id can not be null");
        }
        try {
            JsonObject payload = new JsonObject();
            payload.addProperty(PARAM_JOBID, job.getId());
            HttpRequestBase request = Request.Put("/v1/result", new Object[0]).withContent(payload).build();
            HttpResponse response = this.execute(request);
            String encodedResult = ResponseUtil.getString(response);
            JsonParser parser = new JsonParser();
            return this.formatConcepts(parser.parse(this.decodeResult(encodedResult)).getAsJsonObject());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Job.Status getJobStatus(Job job) {
        if (job == null) {
            throw new IllegalArgumentException("job can not be null");
        }
        if (job.getId() == null) {
            throw new IllegalArgumentException("job.id can not be null");
        }
        HttpRequestBase request = Request.Get("/v1/status", new Object[0]).withQuery(PARAM_JOBID, job.getId()).build();
        try {
            HttpResponse response = this.execute(request);
            JsonObject jsonObject = ResponseUtil.getJsonObject(response);
            return Job.Status.fromString(jsonObject.get(PARAM_STATE).getAsString());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setDataset(ConceptExpansionDataset dataset) {
        this.dataset = dataset;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ConceptExpansion [dataset=");
        builder.append(this.dataset);
        builder.append(", getEndPoint()=");
        builder.append(this.getEndPoint());
        builder.append("]");
        return builder.toString();
    }

    static {
        decoderHash.put("zZzPeriodzZz", ".");
        decoderHash.put("zZzCommazZz", ",");
        decoderHash.put("zZzSlashzZz", "/");
        decoderHash.put("zZzColonzZz", ":");
        decoderHash.put("zZzHashzZz", "#");
        decoderHash.put("zZzStarzZz", "*");
        decoderHash.put("zZzDashzZz", "-");
        decoderHash.put("zZzAmpersandzZz", "&");
        decoderHash.put("zZzPercentzZz", "%");
        decoderHash.put("zZzSemicolonzZz", ";");
        decoderHash.put("zZzUnderbarzZz", "_");
        decoderHash.put("zZzOpenParenzZz", "(");
        decoderHash.put("zZzCloseParenzZz", ")");
        decoderHash.put("zZzPluszZz", "+");
        decoderHash.put("zZzApostrophezZz", "'");
        decoderHash.put("zZzQuestionMarkzZz", "?");
        decoderHash.put("zZzEqualszZz", "=");
        decoderHash.put("zZzDollarzZz", "$");
        decoderHash.put("zZzBackslashzZz", "\\");
        decoderHash.put("zZzPipezZz", "|");
        decoderHash.put("zZzAtzZz", "@");
        decoderHash.put("zZzExclamationzZz", "!");
        decoderHash.put("zZzQuotezZz", "\"");
        decoderHash.put("zZzSquareOpenzZz", "[");
        decoderHash.put("zZzSquareClosezZz", "]");
    }
}

