/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.alchemy.v1.util;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.ibm.watson.developer_cloud.alchemy.v1.model.PublicationDate;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PublicationDateTypeAdapter
extends TypeAdapter<PublicationDate> {
    private final DateFormat df = new SimpleDateFormat("yyyyMMdd'T'HHmmss");
    private static final Logger log = Logger.getLogger(PublicationDateTypeAdapter.class.getName());

    @Override
    public PublicationDate read(JsonReader reader) throws IOException {
        if (reader.peek() == JsonToken.NULL) {
            reader.nextNull();
            return null;
        }
        PublicationDate publicationDate = new PublicationDate();
        publicationDate.setConfident(true);
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("confident")) {
                String confidentAsString = reader.nextString();
                publicationDate.setConfident(confidentAsString == null || !confidentAsString.equals("no"));
                continue;
            }
            if (name.equals("date")) {
                String dateAsString = reader.nextString();
                if (dateAsString == null || dateAsString.isEmpty()) continue;
                try {
                    publicationDate.setDate(this.df.parse(dateAsString));
                }
                catch (ParseException e) {
                    log.log(Level.SEVERE, "Error parsing: " + dateAsString, e);
                }
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return publicationDate;
    }

    @Override
    public void write(JsonWriter writer, PublicationDate value) throws IOException {
        if (value == null) {
            writer.nullValue();
            return;
        }
        writer.beginObject();
        if (value.getDate() != null) {
            writer.name("date").value(this.df.format(value.getDate()));
        }
        if (value.getConfident() != null) {
            writer.name("confident").value(value.getConfident());
        }
        writer.endObject();
        writer.flush();
    }
}

