/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.alchemy.v1;

import com.ibm.watson.developer_cloud.alchemy.v1.model.DocumentsResult;
import com.ibm.watson.developer_cloud.alchemy.v1.model.VolumeResult;
import com.ibm.watson.developer_cloud.service.AlchemyService;
import com.ibm.watson.developer_cloud.service.Request;
import com.ibm.watson.developer_cloud.util.ResponseUtil;
import com.ibm.watson.developer_cloud.util.Validate;
import java.io.IOException;
import java.util.Map;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;

public class AlchemyDataNews
extends AlchemyService {
    public static final String END = "end";
    private static final String NEWS_END_POINT = "/data/GetNews";
    public static final String RETURN = "return";
    public static final String START = "start";
    public static final String TIME_SLICE = "timeSlice";
    public static final String COUNT = "count";

    public DocumentsResult getNewsDocuments(Map<String, Object> parameters) {
        Validate.notNull(parameters.get(START), "start time can't be null");
        Validate.notNull(parameters.get(END), "end time can't be null");
        Validate.notNull(parameters.get(RETURN), "return can't be null");
        parameters.put("outputMode", "json");
        parameters.remove("jsonp");
        Request request = Request.Get(NEWS_END_POINT, new Object[0]);
        for (String param : parameters.keySet()) {
            request.withQuery(param, parameters.get(param));
        }
        HttpRequestBase requestBase = request.build();
        try {
            HttpResponse response = this.execute(requestBase);
            return ResponseUtil.getObject(response, DocumentsResult.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public VolumeResult getVolume(String start, String end, String timeSlice) {
        Validate.notNull(start, "start time can't be null");
        Validate.notNull(end, "end time can't be null");
        Request request = Request.Get(NEWS_END_POINT, new Object[0]);
        request.withQuery(START, start);
        request.withQuery(END, end);
        request.withQuery("outputMode", "json");
        if (timeSlice != null) {
            request.withQuery(TIME_SLICE, timeSlice);
        }
        HttpRequestBase requestBase = request.build();
        try {
            HttpResponse response = this.execute(requestBase);
            return ResponseUtil.getObject(response, VolumeResult.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static enum TimeFormat {
        d,
        h,
        m,
        M,
        NOW,
        s,
        y;

    }
}

