/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.util.EntityUtils;

public class ResponseUtil {
    private static final Logger log = Logger.getLogger(ResponseUtil.class.getName());
    public static final int BUFFER_SIZE = 8192;

    public static String formatJSON(String json) {
        try {
            JsonParser parser = new JsonParser();
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            return gson.toJson(parser.parse(json));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, json + " is not valid", e);
            return json;
        }
    }

    public static JsonElement getJsonElement(HttpResponse response) throws IOException {
        String json = ResponseUtil.getString(response);
        if (json == null || json.length() == 0) {
            throw new IOException("JSON response is empty");
        }
        JsonElement element = new JsonParser().parse(json);
        return element;
    }

    public static JsonArray getJsonArray(HttpResponse response) throws IOException {
        JsonElement json = ResponseUtil.getJsonElement(response);
        return json.getAsJsonArray();
    }

    public static JsonObject getJsonObject(HttpResponse response) throws IOException {
        return ResponseUtil.getJsonElement(response).getAsJsonObject();
    }

    public static String getString(HttpResponse response) throws IOException {
        try {
            HttpEntity entity = response.getEntity();
            if (entity == null) {
                return null;
            }
            return EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        }
        catch (ParseException e) {
            log.log(Level.SEVERE, "Could not parse service response", e);
            throw new IOException("Could not parse service response:" + e.getMessage());
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Could not read service response", e);
            throw new IOException("Could not read service response:" + e.getMessage());
        }
    }

    public static InputStream getInputStream(HttpResponse response) throws IOException {
        InputStream is;
        try {
            is = response.getEntity().getContent();
            if (is == null) {
                return null;
            }
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Could not read service response", e);
            throw new IOException("Could not read service response:" + e.getMessage());
        }
        return is;
    }
}

