/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.NameValuePair;

public class RequestUtil {
    private static final Logger log = Logger.getLogger(RequestUtil.class.getName());

    private static String encode(String content, String encoding) {
        try {
            return URLEncoder.encode(content, encoding != null ? encoding : "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            log.log(Level.SEVERE, encoding + " is not supported", e);
            throw new IllegalArgumentException(e);
        }
    }

    public static String formatQueryString(List<? extends NameValuePair> parameters, String encoding) {
        StringBuilder result = new StringBuilder();
        for (NameValuePair nameValuePair : parameters) {
            String encodedValue;
            String encodedName = RequestUtil.encode(nameValuePair.getName(), encoding);
            String value = nameValuePair.getValue();
            String string = encodedValue = value != null ? RequestUtil.encode(value, encoding) : "";
            if (result.length() > 0) {
                result.append("&");
            }
            result.append(encodedName);
            if (value == null) continue;
            result.append("=");
            result.append(encodedValue);
        }
        return result.toString();
    }
}

