/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.text_to_speech.v1;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.ibm.watson.developer_cloud.service.Request;
import com.ibm.watson.developer_cloud.service.WatsonService;
import com.ibm.watson.developer_cloud.text_to_speech.v1.model.Voice;
import com.ibm.watson.developer_cloud.util.ResponseUtil;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.List;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;

public class TextToSpeech
extends WatsonService {
    private static final String URL = "https://stream.watsonplatform.net/text-to-speech/api";
    private static final Type listVoiceType = new TypeToken<List<Voice>>(){}.getType();

    public TextToSpeech() {
        this.setEndPoint(URL);
    }

    public InputStream synthesize(String text, Voice voice, String format) {
        if (text == null) {
            throw new IllegalArgumentException("text can not be null");
        }
        if (voice == null) {
            throw new IllegalArgumentException("voice can not be null");
        }
        Request request = Request.Get("/v1/synthesize", new Object[0]);
        request.withQuery("text", text);
        request.withQuery("voice", voice.getName());
        if (format != null && !format.startsWith("audio/")) {
            throw new IllegalArgumentException("format needs to be an audio mime type, for example: audio/wav or audio/ogg; codecs=opus");
        }
        request.withQuery("accept", format != null ? format : "audio/wav");
        try {
            HttpResponse response = this.execute(request.build());
            InputStream is = ResponseUtil.getInputStream(response);
            return is;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public InputStream synthesize(String text, Voice voice) {
        return this.synthesize(text, voice, "audio/wav");
    }

    public InputStream synthesize(String text, String format) {
        return this.synthesize(text, Voice.EN_MICHAEL, format);
    }

    public List<Voice> getVoices() {
        HttpRequestBase request = Request.Get("/v1/voices", new Object[0]).build();
        try {
            HttpResponse response = this.execute(request);
            JsonObject jsonObject = ResponseUtil.getJsonObject(response);
            List voices = (List)new Gson().fromJson(jsonObject.get("voices"), listVoiceType);
            return voices;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

