/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.service;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.ibm.watson.developer_cloud.service.BadRequestException;
import com.ibm.watson.developer_cloud.service.ForbiddenException;
import com.ibm.watson.developer_cloud.service.InternalServerErrorException;
import com.ibm.watson.developer_cloud.service.NotFoundException;
import com.ibm.watson.developer_cloud.service.RequestTooLargeException;
import com.ibm.watson.developer_cloud.service.ServiceResponseException;
import com.ibm.watson.developer_cloud.service.ServiceUnavailableException;
import com.ibm.watson.developer_cloud.service.TooManyRequestsException;
import com.ibm.watson.developer_cloud.service.UnauthorizedException;
import com.ibm.watson.developer_cloud.service.UnsupportedException;
import com.ibm.watson.developer_cloud.util.ResponseUtil;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.params.ConnPerRoute;
import org.apache.http.conn.params.ConnPerRouteBean;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;

public abstract class WatsonService {
    private static final String ACCEPT = "Accept";
    private static final String AUTHORIZATION = "Authorization";
    private static final int CONNECTION_TIMEOUT = 120000;
    private static final Logger log = Logger.getLogger(WatsonService.class.getName());
    private static final int MAX_CONNECTIONS_PER_ROUTE = 1000;
    private static final int MAX_TOTAL_CONNECTIONS = 1000;
    private String apiKey;
    private String endPoint;
    private Gson gson = new Gson();
    private HttpClient httpClient;

    private URI buildRequestURI(HttpRequestBase request) {
        String requestURL = this.getEndPoint() + request.getURI();
        try {
            requestURL = this.getEndPoint() + request.getURI();
            return new URI(requestURL);
        }
        catch (URISyntaxException e) {
            log.log(Level.SEVERE, requestURL + " could not be parsed as a URI reference");
            throw new RuntimeException(e);
        }
    }

    protected void executeWithoutResponse(HttpRequestBase request) {
        HttpResponse response = this.execute(request);
        try {
            ResponseUtil.getString(response);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected HttpResponse execute(HttpRequestBase request) {
        HttpResponse response;
        if (this.getApiKey() == null) {
            throw new IllegalArgumentException("apiKey or username and password were not specified");
        }
        request.addHeader(AUTHORIZATION, this.apiKey.startsWith("Basic ") ? this.apiKey : "Basic " + this.apiKey);
        if (this.getEndPoint() == null) {
            throw new IllegalArgumentException("service endpoint was not specified");
        }
        if (!request.containsHeader(ACCEPT)) {
            request.addHeader(ACCEPT, this.getDefaultContentType());
        }
        if (!request.getURI().isAbsolute()) {
            request.setURI(this.buildRequestURI(request));
        }
        log.log(Level.FINEST, "Request to: " + request.getURI());
        try {
            response = this.getThreadSafeClient().execute((HttpUriRequest)request);
        }
        catch (ClientProtocolException e) {
            log.log(Level.SEVERE, "ClientProtocolException", e);
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "IOException", e);
            throw new RuntimeException(e);
        }
        int status = response.getStatusLine().getStatusCode();
        log.log(Level.FINEST, "Response HTTP Status: " + status);
        if (status >= 200 && status < 300) {
            return response;
        }
        String error = this.getErrorMessage(response);
        log.log(Level.SEVERE, "HTTP Status: " + status + ", message: " + error);
        switch (status) {
            case 400: {
                throw new BadRequestException(error != null ? error : "Bad Request");
            }
            case 401: {
                throw new UnauthorizedException("Unauthorized: Access is denied due to invalid credentials");
            }
            case 403: {
                throw new ForbiddenException(error != null ? error : "Forbidden: Service refuse the request");
            }
            case 404: {
                throw new NotFoundException(error != null ? error : "Not found");
            }
            case 406: {
                throw new ForbiddenException(error != null ? error : "Forbidden: Service refuse the request");
            }
            case 413: {
                throw new RequestTooLargeException(error != null ? error : "Request too large: The request entity is larger than the server is able to process");
            }
            case 415: {
                throw new UnsupportedException(error != null ? error : "Unsupported MIME type: The request entity has a media type which the server or resource does not support");
            }
            case 429: {
                throw new TooManyRequestsException(error != null ? error : "Too many requests");
            }
            case 500: {
                throw new InternalServerErrorException(error != null ? error : "Internal Server Error");
            }
            case 503: {
                throw new ServiceUnavailableException(error != null ? error : "Service Unavailable");
            }
        }
        throw new ServiceResponseException(status, error);
    }

    public String getApiKey() {
        return this.apiKey;
    }

    protected String getDefaultContentType() {
        return "application/json";
    }

    protected HttpParams getDefaultRequestParams() {
        BasicHttpParams params = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)120000);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)120000);
        HttpClientParams.setRedirecting((HttpParams)params, (boolean)false);
        HttpProtocolParams.setUserAgent((HttpParams)params, (String)this.getUserAgent());
        ConnManagerParams.setMaxTotalConnections((HttpParams)params, (int)1000);
        ConnManagerParams.setMaxConnectionsPerRoute((HttpParams)params, (ConnPerRoute)new ConnPerRouteBean(1000));
        return params;
    }

    public String getEndPoint() {
        return this.endPoint;
    }

    private String getErrorMessage(HttpResponse response) {
        String error = null;
        try {
            JsonObject jsonObject = ResponseUtil.getJsonObject(response);
            error = jsonObject.has("error") ? jsonObject.get("error").getAsString() : (jsonObject.has("error_message") ? jsonObject.get("error_message").getAsString() : jsonObject.getAsString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return error;
    }

    protected Gson getGson() {
        return this.gson;
    }

    public HttpClient getHttpClient() {
        if (this.httpClient == null) {
            this.httpClient = new DefaultHttpClient(this.getDefaultRequestParams());
        }
        return this.httpClient;
    }

    public HttpClient getThreadSafeClient() {
        DefaultHttpClient client = new DefaultHttpClient(this.getDefaultRequestParams());
        ClientConnectionManager mgr = client.getConnectionManager();
        HttpParams params = client.getParams();
        client = new DefaultHttpClient((ClientConnectionManager)new ThreadSafeClientConnManager(params, mgr.getSchemeRegistry()), params);
        return client;
    }

    private final String getUserAgent() {
        return "watson-developer-cloud-java-wrapper-1.0.1";
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public void setEndPoint(String endPoint) {
        this.endPoint = endPoint;
    }

    public void setUsernameAndPassword(String username, String password) {
        String auth = username + ":" + password;
        this.apiKey = new String(Base64.encodeBase64((byte[])auth.getBytes()));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("WatsonService [");
        if (this.endPoint != null) {
            builder.append("endPoint=");
            builder.append(this.endPoint);
        }
        builder.append("]");
        return builder.toString();
    }
}

