/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.service;

import com.google.gson.JsonObject;
import com.ibm.watson.developer_cloud.util.RequestUtil;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicNameValuePair;

public class Request {
    private static final String UTF_8 = "UTF-8";
    private List<NameValuePair> formParams = new ArrayList<NameValuePair>();
    private List<NameValuePair> headers = new ArrayList<NameValuePair>();
    private List<NameValuePair> queryParams = new ArrayList<NameValuePair>();
    private HttpEntity body;
    private HttpRequestBase method;
    private String url;

    public static Request Delete(String url, Object ... args) {
        return new Request(HttpDelete.class, url, args);
    }

    public static Request Get(String url, Object ... args) {
        return new Request(HttpGet.class, url, args);
    }

    public static Request Post(String url, Object ... args) {
        return new Request(HttpPost.class, url, args);
    }

    public static Request Put(String url, Object ... args) {
        return new Request(HttpPut.class, url, args);
    }

    private <T extends HttpRequestBase> Request(Class<T> method, String url, Object ... args) {
        if (url == null) {
            throw new IllegalArgumentException("url is null");
        }
        if (method == null) {
            throw new IllegalArgumentException("method is null");
        }
        try {
            this.method = (HttpRequestBase)method.newInstance();
            if (args != null && args.length > 0) {
                url = String.format(Locale.ENGLISH, url, args);
            }
            if (url.contains("?")) {
                String query = url.substring(Math.min(url.length(), url.indexOf("?") + 1), url.length());
                for (String s : query.split("&")) {
                    String[] kv = s.split("=", 2);
                    if (kv == null) continue;
                    try {
                        if (kv.length == 2) {
                            this.queryParams.add((NameValuePair)new BasicNameValuePair(URLDecoder.decode(kv[0], UTF_8), URLDecoder.decode(kv[1], UTF_8)));
                            continue;
                        }
                        if (kv.length != 1) continue;
                        this.queryParams.add((NameValuePair)new BasicNameValuePair(URLDecoder.decode(kv[0], UTF_8), null));
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeException(e);
                    }
                }
                this.url = url.substring(0, url.indexOf("?"));
            } else {
                this.url = url;
            }
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private Request add(List<NameValuePair> params, String name, Object value) {
        if (value instanceof Iterable) {
            for (Object o : (Iterable)value) {
                this.addParam(params, name, o);
            }
        } else if (value instanceof Object[]) {
            for (Object o : (Object[])value) {
                this.addParam(params, name, o);
            }
        } else {
            this.addParam(params, name, value);
        }
        return this;
    }

    private void addHeaders(HttpRequestBase method, List<NameValuePair> headers) {
        for (NameValuePair header : headers) {
            method.addHeader(header.getName(), header.getValue());
        }
    }

    private void addParam(List<NameValuePair> params, String name, Object value) {
        params.add((NameValuePair)new BasicNameValuePair(name, value == null ? null : String.valueOf(value)));
    }

    public HttpRequestBase build() {
        this.method.setURI(URI.create(this.toUrl()));
        if (this.method instanceof HttpPost || this.method instanceof HttpPut) {
            HttpEntityEnclosingRequestBase enclosingRequest = (HttpEntityEnclosingRequestBase)this.method;
            if (!this.formParams.isEmpty()) {
                this.withContent(RequestUtil.formatQueryString(this.formParams, UTF_8), "application/x-www-form-urlencoded");
            }
            if (this.body != null) {
                enclosingRequest.setHeader(this.body.getContentType());
                enclosingRequest.setEntity(this.body);
            }
        }
        if (!this.headers.isEmpty()) {
            this.addHeaders(this.method, this.headers);
        }
        return this.method;
    }

    public String toUrl() {
        return this.toUrl(this.url);
    }

    private String toUrl(String url) {
        return this.queryParams.isEmpty() ? url : url + "?" + RequestUtil.formatQueryString(this.queryParams, UTF_8);
    }

    private Request with(List<NameValuePair> params, Object ... args) {
        if (args != null) {
            if (args.length % 2 != 0) {
                throw new IllegalArgumentException("need even number of arguments");
            }
            for (int i = 0; i < args.length; i += 2) {
                this.add(params, args[i].toString(), args[i + 1]);
            }
        }
        return this;
    }

    public Request withContent(JsonObject json) {
        return this.withContent(json.toString(), "application/json");
    }

    public Request withContent(String content, String contentType) {
        try {
            StringEntity stringEntity = new StringEntity(content, UTF_8);
            if (contentType != null) {
                stringEntity.setContentType(contentType);
            }
            return this.withEntity((HttpEntity)stringEntity);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public Request withEntity(HttpEntity entity) {
        this.body = entity;
        return this;
    }

    public Request withForm(Object ... args) {
        return this.with(this.formParams, args);
    }

    public Request withHeader(Object ... args) {
        return this.with(this.headers, args);
    }

    public Request withQuery(Object ... args) {
        return this.with(this.queryParams, args);
    }
}

