/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.personality_insights.v2;

import com.ibm.watson.developer_cloud.personality_insights.v2.model.Profile;
import com.ibm.watson.developer_cloud.service.Request;
import com.ibm.watson.developer_cloud.service.WatsonService;
import com.ibm.watson.developer_cloud.util.ResponseUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.http.HttpResponse;

public class PersonalityInsights
extends WatsonService {
    public static final String ACCEPT_LANGUAGE = "accept_language";
    public static final String CONTENT = "content";
    public static final String INCLUDE_RAW = "include_raw";
    public static final String LANGUAGE = "language";
    public static final String TEXT = "text";
    private static final Logger log = Logger.getLogger(PersonalityInsights.class.getName());
    private static final String URL = "https://gateway.watsonplatform.net/personality-insights/api";

    public PersonalityInsights() {
        this.setEndPoint(URL);
    }

    public Profile getProfile(Map<String, Object> params) {
        if (!params.containsKey(TEXT) && !params.containsKey(CONTENT)) {
            throw new IllegalArgumentException("text or content need to be specified");
        }
        if (params.containsKey(TEXT) && params.containsKey(CONTENT)) {
            log.warning("text and content were specified, only text will be used");
        }
        Request request = Request.Post("/v2/profile", new Object[0]);
        if (params.containsKey(TEXT)) {
            request.withContent(params.get(TEXT).toString(), "text/plain");
        } else {
            String contentJson = this.getGson().toJson(params.get(CONTENT));
            request.withContent(contentJson, "application/json");
        }
        if (params.containsKey(INCLUDE_RAW)) {
            request.withQuery(INCLUDE_RAW, params.get(INCLUDE_RAW));
        }
        if (params.containsKey(LANGUAGE)) {
            request.withHeader("Content-Language", params.get(LANGUAGE));
        }
        if (params.containsKey(ACCEPT_LANGUAGE)) {
            request.withHeader("Accept-Language", params.get(ACCEPT_LANGUAGE));
        }
        HttpResponse response = this.execute(request.build());
        try {
            String profileJson = ResponseUtil.getString(response);
            Profile profile = (Profile)this.getGson().fromJson(profileJson, Profile.class);
            return profile;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Profile getProfile(String text) {
        if (text == null || text.isEmpty()) {
            throw new IllegalArgumentException("text can not be null or empty");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(TEXT, text);
        return this.getProfile(params);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PersonalityInsights [getEndPoint()=");
        builder.append(this.getEndPoint());
        builder.append("]");
        return builder.toString();
    }
}

