/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.natural_language_classifier.v1;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.ibm.watson.developer_cloud.natural_language_classifier.v1.model.Classification;
import com.ibm.watson.developer_cloud.natural_language_classifier.v1.model.Classifier;
import com.ibm.watson.developer_cloud.natural_language_classifier.v1.model.TrainingData;
import com.ibm.watson.developer_cloud.service.Request;
import com.ibm.watson.developer_cloud.service.WatsonService;
import com.ibm.watson.developer_cloud.util.ResponseUtil;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;
import java.util.logging.Logger;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;

public class NaturalLanguageClassifier
extends WatsonService {
    private static String URL = "https://gateway.watsonplatform.net/natural-language-classifier-beta/api";
    private static final Logger log = Logger.getLogger(NaturalLanguageClassifier.class.getName());
    private Type listType = new TypeToken<List<Classifier>>(){}.getType();

    public NaturalLanguageClassifier() {
        this.setEndPoint(URL);
    }

    public Classifier createClassifier(String language, List<TrainingData> trainingData) {
        if (trainingData == null) {
            throw new IllegalArgumentException("data can not be null");
        }
        if (trainingData.isEmpty()) {
            throw new IllegalArgumentException("data needs to have TrainingData items.");
        }
        JsonObject contentJson = new JsonObject();
        if (language != null && !language.isEmpty()) {
            contentJson.addProperty("language", language);
        }
        contentJson.addProperty("training_data", this.getGson().toJson(trainingData));
        log.info("createClassifier with: " + contentJson.getAsString());
        HttpRequestBase request = Request.Post("/v1/classifiers", new Object[0]).withContent(contentJson).build();
        try {
            HttpResponse response = this.execute(request);
            String classifierAsJson = ResponseUtil.getString(response);
            Classifier classifier = (Classifier)this.getGson().fromJson(classifierAsJson, Classifier.class);
            return classifier;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Classification classify(String classifierId, String text) {
        if (classifierId == null || classifierId.isEmpty()) {
            throw new IllegalArgumentException("classifierId can not be null or empty");
        }
        if (text == null || text.isEmpty()) {
            throw new IllegalArgumentException("text can not be null or empty");
        }
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("text", text);
        String path = String.format("/v1/classifiers/%s/classify", classifierId);
        HttpRequestBase request = Request.Post(path, new Object[0]).withContent(contentJson).build();
        try {
            HttpResponse response = this.execute(request);
            String classifierAsJson = ResponseUtil.getString(response);
            Classification classification = (Classification)this.getGson().fromJson(classifierAsJson, Classification.class);
            return classification;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<Classifier> getClassifiers() {
        HttpRequestBase request = Request.Get("/v1/classifiers", new Object[0]).build();
        try {
            HttpResponse response = this.execute(request);
            JsonObject jsonObject = ResponseUtil.getJsonObject(response);
            List classifiers = (List)new Gson().fromJson(jsonObject.get("classifiers"), this.listType);
            return classifiers;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteClassifier(String classifierId) {
        if (classifierId == null || classifierId.isEmpty()) {
            throw new IllegalArgumentException("classifierId can not be null or empty");
        }
        HttpRequestBase request = Request.Delete("/v1/classifiers/" + classifierId, new Object[0]).build();
        this.executeWithoutResponse(request);
    }

    public Classifier getClassifier(String classifierId) {
        if (classifierId == null || classifierId.isEmpty()) {
            throw new IllegalArgumentException("classifierId can not be null or empty");
        }
        HttpRequestBase request = Request.Get("/v1/classifiers/" + classifierId, new Object[0]).build();
        try {
            HttpResponse response = this.execute(request);
            String classifierJson = ResponseUtil.getString(response);
            Classifier classifier = (Classifier)new Gson().fromJson(classifierJson, Classifier.class);
            return classifier;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("NaturalLanguageClassifier [getEndPoint()=");
        builder.append(this.getEndPoint());
        builder.append("]");
        return builder.toString();
    }
}

