/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.machine_translation.v1;

import com.ibm.watson.developer_cloud.machine_translation.v1.model.Language;
import com.ibm.watson.developer_cloud.service.Request;
import com.ibm.watson.developer_cloud.service.WatsonService;
import com.ibm.watson.developer_cloud.util.ResponseUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;

public class MachineTranslation
extends WatsonService {
    private static String URL = "https://gateway.watsonplatform.net/machine-translation-beta/api";
    private static List<String> supportedSids = new ArrayList<String>();

    private static String createSid(Language from, Language to) {
        return String.format("mt-%s-%s", from.getId(), to.getId());
    }

    public MachineTranslation() {
        this.setEndPoint(URL);
    }

    public String translate(String text, Language from, Language to) {
        String sid = MachineTranslation.createSid(from, to);
        if (!supportedSids.contains(sid)) {
            throw new IllegalArgumentException(String.format("Translation from: %s to: %s is not supported.", from, to));
        }
        try {
            HttpRequestBase request = Request.Post("/v1/smt/0", new Object[0]).withForm("sid", sid, "rt", "text", "txt", text).build();
            HttpResponse response = this.execute(request);
            return ResponseUtil.getString(response);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        supportedSids.add("mt-enus-eses");
        supportedSids.add("mt-eses-enus");
        supportedSids.add("mt-enus-frfr");
        supportedSids.add("mt-enus-ptbr");
        supportedSids.add("mt-enus-zhcn");
        supportedSids.add("mt-frfr-enus");
        supportedSids.add("mt-ptbr-enus");
        supportedSids.add("mt-zhcn-enus");
    }
}

