/**
 * Copyright 2015 IBM Corp. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ibm.watson.developer_cloud.natural_language_classifier.v1.model;

import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import com.ibm.watson.developer_cloud.natural_language_classifier.v1.NaturalLanguageClassifier;

/**
 * Classifier used by the {@link NaturalLanguageClassifier} service.
 *
 * @author German Attanasio Ruiz (germanatt@us.ibm.com)
 */
public class Classifier {

	/** The id. */
	@SerializedName("classifier_id")
	private String id;
	
	/** The url. */
	private String url;
	
	/** The status. */
	private Status status;

	/**
	 * The Enum Status.
	 */
	public enum Status {
		
		/** The non existent. */
		@SerializedName("Non Existent")
		NON_EXISTENT,
		
		/** The training. */
		@SerializedName("Training")
		TRAINING,
		
		/** The failed. */
		@SerializedName("Failed")
		FAILED,
		
		/** The available. */
		@SerializedName("Available")
		AVAILABLE,
		
		/** The unavailable. */
		@SerializedName("Unavailable")
		UNAVAILABLE
	}
	
	/** The status description. */
	@SerializedName("status_description")
	private String statusDescription;

	/**
	 * Gets the classifier id.
	 * 
	 * @return the classifier id
	 */
	public String getId() {
		return id;
	}

	/**
	 * Sets the classifier id.
	 * 
	 * @param id
	 *            the new classifier id
	 */
	public void setId(String id) {
		this.id = id;
	}

	/**
	 * Gets the url.
	 * 
	 * @return the url
	 */
	public String getUrl() {
		return url;
	}

	/**
	 * Sets the url.
	 * 
	 * @param url
	 *            the new url
	 */
	public void setUrl(String url) {
		this.url = url;
	}

	/**
	 * Gets the status.
	 * 
	 * @return the status
	 */
	public Status getStatus() {
		return status;
	}

	/**
	 * Sets the status.
	 * 
	 * @param status
	 *            the new status
	 */
	public void setStatus(Status status) {
		this.status = status;
	}

	/**
	 * Gets the status description.
	 * 
	 * @return the status description
	 */
	public String getStatusDescription() {
		return statusDescription;
	}

	/**
	 * Sets the status description.
	 * 
	 * @param statusDescription
	 *            the new status description
	 */
	public void setStatusDescription(String statusDescription) {
		this.statusDescription = statusDescription;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return getClass().getName() + " "
				+ new GsonBuilder().setPrettyPrinting().create().toJson(this);
	}
}
