/**
 * Copyright 2015 IBM Corp. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ibm.watson.developer_cloud.dialog.v1.model;

import com.google.gson.GsonBuilder;
import com.ibm.watson.developer_cloud.dialog.v1.DialogService;

/**
 * Name value class used by the {@link DialogService}.
 *
 * @author German Attanasio Ruiz (germanatt@us.ibm.com)
 */
public class NameValue {

	/** The name. */
	private String name;
	
	/** The value. */
	private String value;


	/**
	 * Instantiates a new name value.
	 */
	public NameValue() {
		super();
	}

	/**
	 * Instantiates a new name value.
	 *
	 * @param name the name
	 * @param value the value
	 */
	public NameValue(String name, String value) {
		super();
		this.name = name;
		this.value = value;
	}

	/**
	 * Gets the name.
	 * 
	 * @return The name
	 */
	public String getName() {
		return name;
	}

	/**
	 * Sets the name.
	 * 
	 * @param name
	 *            The name
	 */
	public void setName(final String name) {
		this.name = name;
	}

	/**
	 * With name.
	 * 
	 * @param name
	 *            the name
	 * @return the name value
	 */
	public NameValue withName(final String name) {
		this.name = name;
		return this;
	}

	/**
	 * Gets the value.
	 * 
	 * @return The value
	 */
	public String getValue() {
		return value;
	}

	/**
	 * Sets the value.
	 * 
	 * @param value
	 *            The value
	 */
	public void setValue(final String value) {
		this.value = value;
	}

	/**
	 * With value.
	 * 
	 * @param value
	 *            the value
	 * @return the name value
	 */
	public NameValue withValue(final String value) {
		this.value = value;
		return this;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return getClass().getName() + " "
				+ new GsonBuilder().setPrettyPrinting().create().toJson(this);
	}
}
