/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.tradeoff_analytics.v1;

import com.ibm.watson.developer_cloud.service.Request;
import com.ibm.watson.developer_cloud.service.WatsonService;
import com.ibm.watson.developer_cloud.tradeoff_analytics.v1.model.Dilemma;
import com.ibm.watson.developer_cloud.tradeoff_analytics.v1.model.Problem;
import com.ibm.watson.developer_cloud.util.ResponseUtil;
import java.io.IOException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;

public class TradeoffAnalytics
extends WatsonService {
    private static final String URL = "https://gateway.watsonplatform.net/tradeoff-analytics/api";

    public TradeoffAnalytics() {
        this.setEndPoint(URL);
    }

    public Dilemma dilemmas(Problem problem) {
        if (problem == null) {
            throw new IllegalArgumentException("problem was not specified");
        }
        String contentJson = this.getGson().toJson(problem);
        HttpRequestBase request = Request.Post("/v1/dilemmas", new Object[0]).withContent(contentJson, "application/json").build();
        try {
            HttpResponse response = this.execute(request);
            String dilemmaJson = ResponseUtil.getString(response);
            Dilemma dilemma = this.getGson().fromJson(dilemmaJson, Dilemma.class);
            return dilemma;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

