/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.tone_analyzer.v1;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.reflect.TypeToken;
import com.ibm.watson.developer_cloud.service.Request;
import com.ibm.watson.developer_cloud.service.WatsonService;
import com.ibm.watson.developer_cloud.tone_analyzer.v1.model.Scorecard;
import com.ibm.watson.developer_cloud.tone_analyzer.v1.model.SynonymResult;
import com.ibm.watson.developer_cloud.tone_analyzer.v1.model.Tone;
import com.ibm.watson.developer_cloud.util.ResponseUtil;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;

public class ToneAnalyzer
extends WatsonService {
    public static final String HOPS = "hops";
    public static final String LIMIT = "limit";
    public static final String CONTEXT = "context";
    public static final String TRAITS = "traits";
    public static final String WORDS = "words";
    public static final String TEXT = "text";
    public static final String SCORECARD = "scorecard";
    private static final String URL = "https://gateway.watsonplatform.net/tone-analyzer-experimental/api";
    private static final Type synonymListType = new TypeToken<List<SynonymResult>>(){}.getType();

    public ToneAnalyzer() {
        this.setEndPoint(URL);
    }

    public Tone getTone(String text) {
        return this.getTone(text, null);
    }

    public Tone getTone(String text, Scorecard scorecard) {
        if (text == null || text.isEmpty()) {
            throw new IllegalArgumentException("text can not be null or empty");
        }
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty(TEXT, text);
        if (scorecard != null) {
            contentJson.addProperty(SCORECARD, scorecard.getId());
        }
        HttpRequestBase request = Request.Post("/v1/tone", new Object[0]).withContent(contentJson).build();
        try {
            HttpResponse response = this.execute(request);
            String toneAsJson = ResponseUtil.getString(response);
            Tone tone = this.getGson().fromJson(toneAsJson, Tone.class);
            return tone;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<SynonymResult> getSynonyms(Map<String, Object> params) {
        String[] words = (String[])params.get(WORDS);
        String[] traits = (String[])params.get(TRAITS);
        String[] contexts = (String[])params.get(CONTEXT);
        if (words == null || words.length == 0) {
            throw new IllegalArgumentException("words can not be null or empty");
        }
        JsonObject contentJson = new JsonObject();
        JsonArray wordsJson = new JsonArray();
        for (String word : words) {
            wordsJson.add(new JsonPrimitive(word));
        }
        contentJson.add(WORDS, wordsJson);
        if (traits != null && traits.length > 0) {
            JsonArray traisJson = new JsonArray();
            for (String trait : traits) {
                traisJson.add(new JsonPrimitive(trait));
            }
            contentJson.add(TRAITS, traisJson);
        }
        if (contexts != null && contexts.length > 0) {
            JsonArray contextsJson = new JsonArray();
            for (String context : contexts) {
                contextsJson.add(new JsonPrimitive(context));
            }
            contentJson.add(CONTEXT, contextsJson);
        }
        if (params.containsKey(LIMIT)) {
            contentJson.addProperty(LIMIT, (Integer)params.get(LIMIT));
        }
        if (params.containsKey(HOPS)) {
            contentJson.addProperty(HOPS, (Integer)params.get(HOPS));
        }
        HttpRequestBase request = Request.Post("/v1/synonym", new Object[0]).withContent(contentJson).build();
        HttpResponse response = this.execute(request);
        try {
            String synonymResultJson = ResponseUtil.getString(response);
            List synonyms = (List)this.getGson().fromJson(synonymResultJson, synonymListType);
            return synonyms;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

