/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ResponseUtil {
    private static final Logger log = Logger.getLogger(ResponseUtil.class.getName());
    public static final int BUFFER_SIZE = 8192;

    public static String formatJSON(String json) {
        try {
            return new JSONObject(json).toString(4);
        }
        catch (JSONException e) {
            log.log(Level.SEVERE, json + " is not a JSONObject", e);
            try {
                return new JSONArray(json).toString(4);
            }
            catch (JSONException e2) {
                log.log(Level.SEVERE, json + " is not a JSONArray", e2);
                return json;
            }
        }
    }

    public static JSONObject getJSON(HttpResponse response) throws IOException {
        String json = ResponseUtil.getString(response);
        if (json == null || json.length() == 0) {
            throw new IOException("JSON response is empty");
        }
        try {
            return new JSONObject(json);
        }
        catch (JSONException e) {
            log.log(Level.SEVERE, json + " is not a JSONObject", e);
            throw new IOException("could not parse JSON document: " + e.getMessage());
        }
    }

    public static JSONArray getJSONArray(HttpResponse response) throws IOException {
        String json = ResponseUtil.getString(response);
        if (json == null || json.length() == 0) {
            throw new IOException("JSON response is empty");
        }
        try {
            return new JSONArray(json);
        }
        catch (JSONException e) {
            log.log(Level.SEVERE, json + " is not a JSONObject", e);
            throw new IOException("could not parse JSON document: " + e.getMessage() + " " + (json.length() > 80 ? json.substring(0, 79) + "..." : json));
        }
    }

    public static String getString(HttpResponse response) throws IOException {
        try {
            int n;
            InputStream is = response.getEntity().getContent();
            if (is == null) {
                return null;
            }
            int length = 8192;
            Header contentLength = response.getFirstHeader("Content-Length");
            if (contentLength != null) {
                try {
                    length = Integer.parseInt(contentLength.getValue());
                }
                catch (NumberFormatException e) {
                    log.log(Level.SEVERE, contentLength.getValue() + " is not a number", e);
                    throw new RuntimeException(e);
                }
            }
            StringBuilder sb = new StringBuilder(length);
            byte[] buffer = new byte[8192];
            while ((n = is.read(buffer)) != -1) {
                sb.append(new String(buffer, 0, n));
            }
            return sb.toString();
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Could not read service response", e);
            throw new IOException("Could not read service response:" + e.getMessage());
        }
    }

    public static InputStream getInputStream(HttpResponse response) throws IOException {
        InputStream is;
        try {
            is = response.getEntity().getContent();
            if (is == null) {
                return null;
            }
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Could not read service response", e);
            throw new IOException("Could not read service response:" + e.getMessage());
        }
        return is;
    }
}

