/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.speech_to_text.v1;

import com.google.gson.Gson;
import com.ibm.watson.developer_cloud.service.Request;
import com.ibm.watson.developer_cloud.service.WatsonService;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.SpeechModel;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.SpeechModelSet;
import com.ibm.watson.developer_cloud.speech_to_text.v1.model.SpeechResults;
import com.ibm.watson.developer_cloud.util.ResponseUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.InputStreamEntity;
import org.json.JSONObject;

public class SpeechToText
extends WatsonService {
    private static String URL = "https://stream.watsonplatform.net/speech-to-text-beta/api";

    public SpeechToText() {
        this.setEndPoint(URL);
    }

    public SpeechModel getModel(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name was not specified");
        }
        HttpRequestBase request = Request.Get("/v1/models/" + name, new Object[0]).build();
        try {
            HttpResponse response = this.execute(request);
            String resultJson = ResponseUtil.getString(response);
            SpeechModel model = (SpeechModel)new Gson().fromJson(resultJson, SpeechModel.class);
            return model;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String createSession() {
        HttpRequestBase request = Request.Post("/v1/sessions", new Object[0]).build();
        try {
            HttpResponse response = this.execute(request);
            JSONObject sessionJson = ResponseUtil.getJSON(response);
            if (response.getStatusLine().getStatusCode() != 201) {
                throw new RuntimeException("Cound't create a session:" + sessionJson.getString("error"));
            }
            String sessionId = sessionJson.getString("session_id");
            return sessionId;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteSession(String sessionId) {
        if (sessionId == null) {
            throw new IllegalArgumentException("sessionId was not specified");
        }
        HttpRequestBase request = Request.Delete("/v1/sessions/" + sessionId, new Object[0]).build();
        HttpResponse response = this.execute(request);
        if (response.getStatusLine().getStatusCode() != 204) {
            throw new RuntimeException("Cound't delete session");
        }
    }

    public List<SpeechModel> getModels() {
        HttpRequestBase request = Request.Get("/v1/models", new Object[0]).build();
        try {
            HttpResponse response = this.execute(request);
            String speechModelsJson = ResponseUtil.getString(response);
            SpeechModelSet speechModels = (SpeechModelSet)new Gson().fromJson(speechModelsJson, SpeechModelSet.class);
            return speechModels.getModels();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public SpeechResults recognize(File audio, String contentType) {
        return this.recognize(audio, contentType, null, false);
    }

    public SpeechResults recognize(File audio, String contentType, String session, boolean continuous) {
        if (audio == null || !audio.exists() || !audio.isFile()) {
            throw new IllegalArgumentException("audio is not a valid audio file");
        }
        if (contentType == null) {
            throw new IllegalArgumentException("contentType was not specified");
        }
        StringBuilder urlBuider = new StringBuilder();
        urlBuider.append("/v1");
        urlBuider.append(session != null ? "/sessions/" + session : "");
        urlBuider.append("/recognize");
        Request request = Request.Post(urlBuider.toString(), new Object[0]);
        request.withHeader("Content-Type", contentType);
        InputStreamEntity reqEntity = null;
        try {
            reqEntity = new InputStreamEntity((InputStream)new FileInputStream(audio), -1L);
            reqEntity.setContentType(contentType);
            reqEntity.setChunked(true);
            request.withEntity((HttpEntity)reqEntity);
            HttpResponse response = this.execute(request.build());
            String speechResultJson = ResponseUtil.getString(response);
            SpeechResults speechResults = (SpeechResults)new Gson().fromJson(speechResultJson, SpeechResults.class);
            return speechResults;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public SpeechModel getModel(SpeechModel watsonModel) {
        return this.getModel(watsonModel.getName());
    }
}

