/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.relationship_extraction.v1;

import com.ibm.watson.developer_cloud.relationship_extraction.v1.model.RelationshipExtractionDataset;
import com.ibm.watson.developer_cloud.service.Request;
import com.ibm.watson.developer_cloud.service.WatsonService;
import com.ibm.watson.developer_cloud.util.ResponseUtil;
import java.io.IOException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;

public class RelationshipExtraction
extends WatsonService {
    private static String URL = "https://gateway.watsonplatform.net/relationship-extraction-beta/api";
    private RelationshipExtractionDataset dataset;

    public RelationshipExtraction() {
        this.setEndPoint(URL);
    }

    public String extract(String text) {
        if (this.dataset == null) {
            throw new IllegalArgumentException("dataset can not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("text can not be null");
        }
        HttpRequestBase request = Request.Post("/v1/sire/0", new Object[0]).withForm("sid", this.dataset.getId(), "rt", "xml", "txt", text).build();
        String relations = null;
        try {
            HttpResponse response = this.execute(request);
            relations = ResponseUtil.getString(response);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return relations;
    }

    public RelationshipExtractionDataset getDataset() {
        return this.dataset;
    }

    public void setDataset(RelationshipExtractionDataset dataset) {
        this.dataset = dataset;
    }
}

