/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.personality_insights.v2;

import com.ibm.watson.developer_cloud.personality_insights.v2.model.Content;
import com.ibm.watson.developer_cloud.personality_insights.v2.model.Profile;
import com.ibm.watson.developer_cloud.service.Request;
import com.ibm.watson.developer_cloud.service.WatsonService;
import com.ibm.watson.developer_cloud.util.ResponseUtil;
import java.io.IOException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;

public class PersonalityInsights
extends WatsonService {
    private static String URL = "https://gateway.watsonplatform.net/personality-insights/api";

    public PersonalityInsights() {
        this.setEndPoint(URL);
    }

    public Profile getProfile(Content content) {
        if (content == null) {
            throw new IllegalArgumentException("content can not be null");
        }
        if (content.getContentItems() == null || content.getContentItems().isEmpty()) {
            throw new IllegalArgumentException("content needs to have contentItems.");
        }
        String contentJson = this.getGson().toJson((Object)content);
        HttpRequestBase request = Request.Post("/v2/profile", new Object[0]).withContent(contentJson, "application/json").build();
        try {
            HttpResponse response = this.execute(request);
            String profileJson = ResponseUtil.getString(response);
            Profile profile = (Profile)this.getGson().fromJson(profileJson, Profile.class);
            return profile;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Profile getProfile(String text) {
        if (text == null) {
            throw new IllegalArgumentException("text can not be null");
        }
        HttpRequestBase request = Request.Post("/v2/profile", new Object[0]).withContent(text, "text/plain").build();
        HttpResponse response = this.execute(request);
        try {
            String profileJson = ResponseUtil.getString(response);
            Profile profile = (Profile)this.getGson().fromJson(profileJson, Profile.class);
            return profile;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PersonalityInsights [getEndPoint()=");
        builder.append(this.getEndPoint());
        builder.append("]");
        return builder.toString();
    }
}

