/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.concept_expansion.v1;

import com.ibm.watson.developer_cloud.concept_expansion.v1.model.Concept;
import com.ibm.watson.developer_cloud.concept_expansion.v1.model.ConceptExpansionDataset;
import com.ibm.watson.developer_cloud.concept_expansion.v1.model.Job;
import com.ibm.watson.developer_cloud.service.Request;
import com.ibm.watson.developer_cloud.service.WatsonService;
import com.ibm.watson.developer_cloud.util.ResponseUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ConceptExpansion
extends WatsonService {
    private static final String PARAM_STATE = "state";
    private static final String PARAM_JOBID = "jobid";
    private static String URL = "https://gateway.watsonplatform.net/concept-expansion-beta/api";
    private static final Map<String, String> decoderHash = new HashMap<String, String>();
    private ConceptExpansionDataset dataset;

    public ConceptExpansion() {
        this.setEndPoint(URL);
    }

    public Job createJob(String label, String[] seeds) {
        if (this.dataset == null) {
            throw new IllegalArgumentException("dataset can not be null");
        }
        if (label == null) {
            throw new IllegalArgumentException("label can not be null");
        }
        if (seeds == null) {
            throw new IllegalArgumentException("seeds can not be null");
        }
        try {
            JSONObject payload = new JSONObject();
            payload.put("label", (Object)label);
            payload.put("dataset", (Object)this.dataset.getId());
            payload.put("seeds", (Object)seeds);
            HttpRequestBase request = Request.Post("/v1/upload", new Object[0]).withContent(payload).build();
            HttpResponse response = this.execute(request);
            String jsonJob = ResponseUtil.getString(response);
            return (Job)this.getGson().fromJson(jsonJob, Job.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    private String decodeResult(String result) {
        for (String key : decoderHash.keySet()) {
            result = result.replaceAll(" " + key, decoderHash.get(key));
            result = result.replaceAll(key, decoderHash.get(key));
        }
        return result;
    }

    private Concept formatConcept(JSONObject conceptJson) throws JSONException {
        return new Concept(conceptJson.getString("result"), conceptJson.getInt("prevalence"));
    }

    private List<Concept> formatConcepts(JSONObject conceptsJson) throws JSONException {
        JSONArray conceptArray = conceptsJson.getJSONArray("return_seeds");
        ArrayList<Concept> concepts = new ArrayList<Concept>();
        for (int i = 0; i < conceptArray.length(); ++i) {
            concepts.add(this.formatConcept(conceptArray.getJSONObject(i)));
        }
        return concepts;
    }

    public ConceptExpansionDataset getDataset() {
        return this.dataset;
    }

    public List<Concept> getJobResult(Job job) {
        if (job == null) {
            throw new IllegalArgumentException("job can not be null");
        }
        if (job.getId() == null) {
            throw new IllegalArgumentException("job.id can not be null");
        }
        try {
            JSONObject payload = new JSONObject();
            payload.put(PARAM_JOBID, (Object)job.getId());
            HttpRequestBase request = Request.Put("/v1/result", new Object[0]).withContent(payload).build();
            HttpResponse response = this.execute(request);
            String encodedResult = ResponseUtil.getString(response);
            return this.formatConcepts(new JSONObject(this.decodeResult(encodedResult)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public Job.Status getJobStatus(Job job) {
        if (job == null) {
            throw new IllegalArgumentException("job can not be null");
        }
        if (job.getId() == null) {
            throw new IllegalArgumentException("job.id can not be null");
        }
        HttpRequestBase request = Request.Get("/v1/status", new Object[0]).withQuery(PARAM_JOBID, job.getId()).build();
        try {
            HttpResponse response = this.execute(request);
            JSONObject ret = ResponseUtil.getJSON(response);
            return Job.Status.fromString(ret.getString(PARAM_STATE));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public void setDataset(ConceptExpansionDataset dataset) {
        this.dataset = dataset;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ConceptExpansion [dataset=");
        builder.append(this.dataset);
        builder.append(", getEndPoint()=");
        builder.append(this.getEndPoint());
        builder.append("]");
        return builder.toString();
    }

    static {
        decoderHash.put("zZzPeriodzZz", ".");
        decoderHash.put("zZzCommazZz", ",");
        decoderHash.put("zZzSlashzZz", "/");
        decoderHash.put("zZzColonzZz", ":");
        decoderHash.put("zZzHashzZz", "#");
        decoderHash.put("zZzStarzZz", "*");
        decoderHash.put("zZzDashzZz", "-");
        decoderHash.put("zZzAmpersandzZz", "&");
        decoderHash.put("zZzPercentzZz", "%");
        decoderHash.put("zZzSemicolonzZz", ";");
        decoderHash.put("zZzUnderbarzZz", "_");
        decoderHash.put("zZzOpenParenzZz", "(");
        decoderHash.put("zZzCloseParenzZz", ")");
        decoderHash.put("zZzPluszZz", "+");
        decoderHash.put("zZzApostrophezZz", "'");
        decoderHash.put("zZzQuestionMarkzZz", "?");
        decoderHash.put("zZzEqualszZz", "=");
        decoderHash.put("zZzDollarzZz", "$");
        decoderHash.put("zZzBackslashzZz", "\\");
        decoderHash.put("zZzPipezZz", "|");
        decoderHash.put("zZzAtzZz", "@");
        decoderHash.put("zZzExclamationzZz", "!");
        decoderHash.put("zZzQuotezZz", "\"");
        decoderHash.put("zZzSquareOpenzZz", "[");
        decoderHash.put("zZzSquareClosezZz", "]");
    }
}

