/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.visual_recognition.v1;

import com.google.gson.Gson;
import com.ibm.watson.developer_cloud.service.Request;
import com.ibm.watson.developer_cloud.service.WatsonService;
import com.ibm.watson.developer_cloud.util.ResponseUtil;
import com.ibm.watson.developer_cloud.visual_recognition.v1.model.LabelSet;
import com.ibm.watson.developer_cloud.visual_recognition.v1.model.RecognizedImage;
import com.ibm.watson.developer_cloud.visual_recognition.v1.model.VisualRecognitionImages;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;

public class VisualRecognition
extends WatsonService {
    private static String URL = "https://gateway.watsonplatform.net/visual-recognition-beta/api";

    public VisualRecognition() {
        this.setEndPoint(URL);
    }

    public RecognizedImage recognize(File image, LabelSet labelSet) {
        if (image == null) {
            throw new IllegalArgumentException("image can not be null");
        }
        try {
            Request request = Request.Post("/v1/tag/recognize", new Object[0]);
            MultipartEntity reqEntity = new MultipartEntity();
            FileBody bin = new FileBody(image);
            reqEntity.addPart("imgFile", bin);
            if (labelSet != null) {
                StringBody labels = new StringBody(new Gson().toJson(labelSet), Charset.forName("UTF-8"));
                reqEntity.addPart("labels_to_check", labels);
            }
            request.withEntity(reqEntity);
            HttpResponse response = this.execute(request.build());
            String resultJson = ResponseUtil.getString(response);
            VisualRecognitionImages recognizedImages = new Gson().fromJson(resultJson, VisualRecognitionImages.class);
            return recognizedImages.getImages().get(0);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public LabelSet getLabelSet() {
        HttpRequestBase request = Request.Get("/v1/tag/labels", new Object[0]).build();
        try {
            HttpResponse response = this.execute(request);
            String jsonLabelSet = ResponseUtil.getString(response);
            return new Gson().fromJson(jsonLabelSet, LabelSet.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public RecognizedImage recognize(File image) {
        return this.recognize(image, null);
    }
}

