/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.language_identification.v1;

import com.ibm.watson.developer_cloud.language_identification.v1.model.IdentifiedLanguage;
import com.ibm.watson.developer_cloud.service.Request;
import com.ibm.watson.developer_cloud.service.WatsonService;
import com.ibm.watson.developer_cloud.util.ResponseUtil;
import java.io.IOException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.json.JSONException;
import org.json.JSONObject;

public class LanguageIdentification
extends WatsonService {
    private static String URL = "https://gateway.watsonplatform.net/language-identification-beta/api";

    public LanguageIdentification() {
        this.setEndPoint(URL);
    }

    public IdentifiedLanguage identify(String text) {
        HttpRequestBase request = Request.Post("/v1/txtlid/0", new Object[0]).withForm("sid", "lid-generic", "rt", "json", "txt", text).build();
        try {
            HttpResponse response = this.execute(request);
            JSONObject ret = ResponseUtil.getJSON(response);
            return new IdentifiedLanguage(ret.getString("lang"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("LanguageIdentification [getEndPoint()=");
        builder.append(this.getEndPoint());
        builder.append("]");
        return builder.toString();
    }
}

